<?php

require_once __DIR__ . '/core/Sql.php';

$dataInicio = $_POST['dataInicio'];
$dataFim = $_POST['dataFim'];
$atendente = $_POST['atendente'];

try {
    $sql = new Sql();
    $conn = $sql->getConnection();

    $query = "
        SELECT id, atendente, fechadoem, titulo
        FROM chamados
        WHERE fechadoem BETWEEN :start_time AND :end_time
        AND status = 'Fechado'
    ";

    if ($atendente !== 'todos') {
        $query .= " AND atendente = :atendente";
    }

    $query .= " AND fila_id IN ('15','10','12','35','36')
                ORDER BY atendente, id";

    $stmt = $conn->prepare($query);

    $start_time = "$dataInicio 00:01:00";
    $end_time = "$dataFim 23:59:59";

    $stmt->bindParam(':start_time', $start_time);
    $stmt->bindParam(':end_time', $end_time);

    if ($atendente !== 'todos') {
        $stmt->bindParam(':atendente', $atendente);
    }

    $stmt->execute();

    // Obtendo os resultados e convertendo para o formato esperado pelo DataTables
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $formattedResults = array_map(function($row) {
        return [
            $row['id'],
            $row['atendente'],
            $row['fechadoem'],
            $row['titulo']
        ];
    }, $results);

    // Contagem total de atendimentos
    $queryTotalGeral = "SELECT COUNT(*) as total FROM chamados WHERE fechadoem BETWEEN :start_time AND :end_time AND status = 'Fechado' AND fila_id IN ('15','10','12','35','36')";
    $stmtTotalGeral = $conn->prepare($queryTotalGeral);
    $stmtTotalGeral->bindParam(':start_time', $start_time);
    $stmtTotalGeral->bindParam(':end_time', $end_time);
    $stmtTotalGeral->execute();
    $totalGeral = $stmtTotalGeral->fetch(PDO::FETCH_ASSOC)['total'];

    // Contagem total de atendimentos do analista
    $totalAnalista = count($results);

    // Calcular porcentagem
    $porcentagem = $totalGeral > 0 ? ($totalAnalista / $totalGeral) * 100 : 0;

    // Envia os resultados como JSON
    echo json_encode([
        'data' => $formattedResults,
        'totalAnalista' => $totalAnalista,
        'totalGeral' => $totalGeral,
        'porcentagem' => $porcentagem
    ]);

} catch (PDOException $e) {
    echo json_encode(['error' => $e->getMessage()]);
}

?>
