<?php

$analistas = [
    "Gabriel Lucas",
    "Thiago Carvalho",
    "Rony Ferreira",
    "Nicolas Parreiras",
    "Eduardo Oliveira",
    "Laura Cabral",
    "Debora Nunes",
    "Bruna Olimpio",
    "Débora Valois"
];

?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Consulta de Chamados</title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
</head>
<body>
    <div class="container">
        <h1>Consulta de Chamados</h1>
        <form id="consulta-form">
            <label for="dataInicio">Data de Início:</label>
            <input type="date" id="dataInicio" name="dataInicio" required>

            <label for="dataFim">Data de Fim:</label>
            <input type="date" id="dataFim" name="dataFim" required>

            <label for="atendente">Atendente:</label>
            <select id="atendente" name="atendente" required>
                <option value="todos">Todos</option>
                <?php foreach ($analistas as $analista): ?>
                    <option value="<?php echo $analista; ?>"><?php echo $analista; ?></option>
                <?php endforeach; ?>
            </select>

            <button type="submit">Consultar</button>
        </form>

        <div id="informacoes" style="margin-top: 20px;">
            <h2>Resumo dos Atendimentos</h2>
            <p>Total de Atendimentos do Analista: <span id="totalAnalista"></span></p>
            <p>Total de Atendimentos Geral: <span id="totalGeral"></span></p>
            <p>Porcentagem dos Atendimentos: <span id="porcentagem"></span></p>
        </div>

        <div id="resultados" style="margin-top: 20px;">
            <table id="resultados-tabela" class="display" style="width:100%">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Atendente</th>
                        <th>Fechado em</th>
                        <th>Título</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- Os dados serão inseridos aqui via AJAX -->
                </tbody>
            </table>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            var table = $('#resultados-tabela').DataTable({
                responsive: true,
                paging: false // Desativa a paginação
            });

            $('#consulta-form').on('submit', function(e) {
                e.preventDefault();

                $.ajax({
                    type: 'POST',
                    url: 'consulta_chamados.php',
                    data: $(this).serialize(),
                    dataType: 'json',
                    success: function(response) {
                        table.clear();
                        table.rows.add(response.data);
                        table.draw();

                        $('#totalAnalista').text(response.totalAnalista);
                        $('#totalGeral').text(response.totalGeral);
                        $('#porcentagem').text(response.porcentagem.toFixed(2) + '%');
                    },
                    error: function(xhr, status, error) {
                        console.error("Erro na consulta: ", status, error);
                    }
                });
            });
        });
    </script>
</body>
</html>
