<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Inclui a classe de conexão
require '../db.php'; // Ajuste o caminho se necessário

try {
    // Instancia a classe
    $db = new Sql();

    // Filtros opcionais via GET
    $statusFiltro = $_GET['status'] ?? null;
    $busca = $_GET['busca'] ?? null;

    // Monta a cláusula WHERE
    $where = [];
    $params = [];

    // Filtro de status
    if ($statusFiltro) {
        $where[] = "LOWER(ch.status) = LOWER(:status)";
        $params[':status'] = $statusFiltro;
    }

    // Filtro de busca por cliente ou título
    if ($busca) {
        $where[] = "(LOWER(cl.nome_fantasia) LIKE LOWER(:busca) OR LOWER(ch.titulo) LIKE LOWER(:busca))";
        $params[':busca'] = "%$busca%";
    }

    // Filtra apenas setores Suporte e Relacionamento
    $where[] = "(ch.setor = 'Suporte' OR ch.setor = 'Relacionamento')";

    $whereSql = $where ? 'WHERE ' . implode(' AND ', $where) : '';

    // Consulta os últimos 50 chamados
    $sql = "
        SELECT ch.id, ch.titulo, ch.status, ch.abertopor, ch.atendente,
               ch.pegoem, ch.fechadoem, ch.setor, cl.nome_fantasia AS cliente
        FROM chamados ch
        LEFT JOIN clientes cl ON ch.cliente_id = cl.id
        $whereSql
        ORDER BY ch.id DESC
        LIMIT 50
    ";

    $chamados = $db->query($sql, $params)->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Erro na conexão ou consulta: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <title>Chamados - Suporte e Relacionamento</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body>
    <div class="container mt-4">
        <h1>Chamados - Suporte e Relacionamento</h1>

        <hr>

        <!-- Filtros -->
        <form method="get" class="row g-3 mb-4">
            <div class="col-md-3">
                <input type="text" name="busca" class="form-control" placeholder="Buscar cliente ou título" value="<?= htmlspecialchars((string)($busca ?? '')) ?>">

            </div>
            <div class="col-md-3">
                <select name="status" class="form-select">
                    <option value="">Todos os status</option>
                    <option value="Aberto" <?= $statusFiltro === 'Aberto' ? 'selected' : '' ?>>Aberto</option>
                    <option value="Fechado" <?= $statusFiltro === 'Fechado' ? 'selected' : '' ?>>Fechado</option>
                    <option value="Pendente" <?= $statusFiltro === 'Pendente' ? 'selected' : '' ?>>Pendente</option>
                </select>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-primary">Filtrar</button>
            </div>
        </form>

        <!-- Tabela de Chamados -->
        <table class="table table-striped table-hover">
            <thead class="table-dark">
                <tr>
                    <th>ID</th>
                    <th>Cliente</th>
                    <th>Título</th>
                    <th>Status</th>
                    <th>Abertor</th>
                    <th>Atendente</th>
                    <th>Data Abertura</th>
                    <th>Data Fechamento</th>
                    <th>Setor</th>
                </tr>
            </thead>
            <tbody>
            <tbody>
            <tbody>
                <?php foreach ($chamados as $ch): ?>
                    <tr>
                        <td><?= htmlspecialchars((string)($ch['cliente'] ?? '')) ?></td>
                        <td><?= htmlspecialchars((string)($ch['titulo'] ?? '')) ?></td>
                        <td><?= htmlspecialchars((string)($ch['status'] ?? '')) ?></td>
                        <td><?= htmlspecialchars((string)($ch['abertopor'] ?? '')) ?></td>
                        <td><?= htmlspecialchars((string)($ch['atendente'] ?? '')) ?></td>
                        <td><?= $ch['pegoem'] ? date('d/m/Y H:i', strtotime($ch['pegoem'])) : '-' ?></td>
                        <td><?= $ch['fechadoem'] ? date('d/m/Y H:i', strtotime($ch['fechadoem'])) : '-' ?></td>
                        <td><?= htmlspecialchars((string)($ch['setor'] ?? '')) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>



</html>