<?php
require_once "../db.php"; // Ajuste o caminho se necessário

// Recebendo os filtros da URL (GET)
$nome = $_GET['nome'] ?? '';
$status = $_GET['status'] ?? '';

// Montando a query
$query = "SELECT nome_fantasia, cnpj, ativo, data_criacao, telefone, email FROM clientes WHERE 1=1";
$params = [];

if ($nome) {
    $query .= " AND nome_fantasia ILIKE :nome";
    $params[':nome'] = "%$nome%";
}

if ($status !== '' && ($status == '1' || $status == '0')) {
    $query .= " AND ativo = :status";
    $params[':status'] = $status;
}

$query .= " ORDER BY id LIMIT 20";

try {
    $db = new Sql();
    $clientes = $db->rowquery($query, $params);
} catch (PDOException $e) {
    die("Erro ao buscar clientes: " . $e->getMessage());
}
?>
<!doctype html>
<html lang="pt-br">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Clientes</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f8f9fa;
        }

        .table-hover tbody tr:hover {
            background-color: #e2f0ff;
        }

        .badge-status {
            font-size: 0.9rem;
            padding: 0.4em 0.7em;
        }

        .filter-bar {
            margin-bottom: 1rem;
        }
    </style>
</head>

<body>
    <div class="container py-4">
        <h1 class="mb-4">Lista de Clientes</h1>

        <!-- Barra de filtros -->
        <form method="get" class="row filter-bar">
            <div class="col-md-4 mb-2">
                <input type="text" name="nome" value="<?= htmlspecialchars($nome) ?>" class="form-control" placeholder="Pesquisar por nome...">
            </div>
            <div class="col-md-4 mb-2">
                <select name="status" class="form-select">
                    <option value="">Todos os status</option>
                    <option value="1" <?= $status === '1' ? 'selected' : '' ?>>Ativo</option>
                    <option value="0" <?= $status === '0' ? 'selected' : '' ?>>Inativo</option>
                </select>
            </div>
            <div class="col-md-4 mb-2 d-flex">
                <button type="submit" class="btn btn-primary me-2">Pesquisar</button>
                <a href="index.php" class="btn btn-secondary">Limpar</a>
            </div>
        </form>

        <!-- Tabela de clientes -->
        <div class="table-responsive">
            <table class="table table-bordered table-hover align-middle">
                <thead class="table-dark">
                    <tr>
                        <th>Nome Fantasia</th>
                        <th>CNPJ</th>
                        <th>Status</th>
                        <th>Data de Cadastro</th>
                        <th>Contato Rápido</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (count($clientes) > 0): ?>
                        <?php foreach ($clientes as $cliente): ?>
                            <tr>
                                <td><?= htmlspecialchars($cliente['nome_fantasia']) ?></td>
                                <td><?= htmlspecialchars($cliente['cnpj']) ?></td>
                                <td>
                                    <?php if ($cliente['ativo']): ?>
                                        <span class="badge bg-success badge-status">Ativo</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger badge-status">Inativo</span>
                                    <?php endif; ?>
                                </td>
                                <td><?= date('d/m/Y', strtotime($cliente['data_criacao'])) ?></td>
                                <td>
                                    <?php if ($cliente['telefone']): ?>
                                        <a href="tel:<?= $cliente['telefone'] ?>" class="badge bg-info text-dark">📞 <?= $cliente['telefone'] ?></a>
                                    <?php endif; ?>
                                    <?php if ($cliente['email']): ?>
                                        <a href="mailto:<?= $cliente['email'] ?>" class="badge bg-warning text-dark">✉ <?= $cliente['email'] ?></a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5" class="text-center">Nenhum cliente encontrado</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Bootstrap 5 JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>