<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require '../db.php'; // Conexão

try {
    $db = new Sql();

    // Últimas 20 cobranças
    $cobrancas = $db->rowquery("
        SELECT c.id, c.valor, c.desconto, c.valor_servicos, cl.nome_fantasia AS cliente
        FROM cobrancas c
        JOIN clientes cl ON c.cliente_id = cl.id
        ORDER BY c.id DESC
        LIMIT 20
    ");

    // Últimos 20 boletos
    $boletos = $db->rowquery("
        SELECT b.id, cl.nome_fantasia AS cliente, b.valor, b.status
        FROM cobrancasboleto b
        JOIN clientes cl ON b.cliente_id = cl.id
        ORDER BY b.id DESC
        LIMIT 20
    ");

    // Últimos 20 cartões
    $cartoes = $db->rowquery("
        SELECT cc.id, cl.nome_fantasia AS cliente, cc.valor, cc.status, cc.data_criacao
        FROM cobrancascartao cc
        JOIN clientes cl ON cc.cliente_id = cl.id
        ORDER BY cc.data_criacao DESC
        LIMIT 20
    ");

    // Últimos 20 títulos
    $titulos = $db->rowquery("
        SELECT t.id, cl.nome_fantasia AS cliente, t.valor, t.data_emissao, t.vencimento, t.data_pagamento
        FROM titulos t
        JOIN cobrancas c ON t.cobranca_id = c.id
        JOIN clientes cl ON c.cliente_id = cl.id
        ORDER BY t.data_emissao DESC
        LIMIT 20
    ");

    // Últimos 20 extratos de pagamento de afiliados
    $extratos = $db->rowquery("
        SELECT e.id, cl.nome_fantasia AS cliente, e.valor, e.data, e.descricao
        FROM extrato_pagamento_afiliados e
        JOIN clientes cl ON e.cliente_id = cl.id
        ORDER BY e.data DESC
        LIMIT 20
    ");

    // Últimos 20 faturamentos
    $faturamentos = $db->rowquery("
        SELECT f.id, f.valor_faturado, f.data_vencimento, f.total_cobrancas
        FROM faturamentos f
        ORDER BY f.data_vencimento DESC
        LIMIT 20
    ");
} catch (PDOException $e) {
    die("Erro na conexão ou consulta: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta charset="UTF-8">
    <title>Financeiro</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body>
    <div class="container mt-4">
        <h1 class="mb-4">Financeiro</h1>

        <?php
        function formatValor($valor)
        {
            return is_null($valor) ? '0,00' : number_format($valor, 2, ',', '.');
        }
        function formatData($data)
        {
            return $data ? date('d/m/Y', strtotime($data)) : '-';
        }
        ?>

        <!-- Cobranças -->
        <div class="card mb-4 shadow-sm">
            <div class="card-header bg-primary text-white">
                Cobranças Recentes
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-striped table-hover mb-0">
                        <thead class="table-dark">
                            <tr>
                                <th>ID</th>
                                <th>Cliente</th>
                                <th>Valor</th>
                                <th>Desconto</th>
                                <th>Valor Serviços</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($cobrancas as $c): ?>
                                <tr>
                                    <td><?= $c['id'] ?></td>
                                    <td><?= htmlspecialchars($c['cliente']) ?></td>
                                    <td><?= formatValor($c['valor']) ?></td>
                                    <td><?= formatValor($c['desconto']) ?></td>
                                    <td><?= formatValor($c['valor_servicos']) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Boletos -->
        <div class="card mb-4 shadow-sm">
            <div class="card-header bg-success text-white">
                Boletos Recentes
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-striped table-hover mb-0">
                        <thead class="table-dark">
                            <tr>
                                <th>ID</th>
                                <th>Cliente</th>
                                <th>Valor</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($boletos as $b): ?>
                                <tr>
                                    <td><?= $b['id'] ?></td>
                                    <td><?= htmlspecialchars($b['cliente']) ?></td>
                                    <td><?= formatValor($b['valor']) ?></td>
                                    <td><?= htmlspecialchars($b['status']) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Cartões -->
        <div class="card mb-4 shadow-sm">
            <div class="card-header bg-info text-white">
                Cartões Recentes
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-striped table-hover mb-0">
                        <thead class="table-dark">
                            <tr>
                                <th>ID</th>
                                <th>Cliente</th>
                                <th>Valor</th>
                                <th>Status</th>
                                <th>Data Criação</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($cartoes as $cc): ?>
                                <tr>
                                    <td><?= $cc['id'] ?></td>
                                    <td><?= htmlspecialchars($cc['cliente']) ?></td>
                                    <td><?= formatValor($cc['valor']) ?></td>
                                    <td><?= htmlspecialchars($cc['status']) ?></td>
                                    <td><?= formatData($cc['data_criacao']) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Títulos -->
        <div class="card mb-4 shadow-sm">
            <div class="card-header bg-warning text-dark">
                Títulos Recentes
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-striped table-hover mb-0">
                        <thead class="table-dark">
                            <tr>
                                <th>ID</th>
                                <th>Cliente</th>
                                <th>Valor</th>
                                <th>Data Emissão</th>
                                <th>Vencimento</th>
                                <th>Data Pagamento</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($titulos as $t): ?>
                                <tr>
                                    <td><?= $t['id'] ?></td>
                                    <td><?= htmlspecialchars($t['cliente']) ?></td>
                                    <td><?= formatValor($t['valor']) ?></td>
                                    <td><?= formatData($t['data_emissao']) ?></td>
                                    <td><?= formatData($t['vencimento']) ?></td>
                                    <td><?= formatData($t['data_pagamento']) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Extratos -->
        <div class="card mb-4 shadow-sm">
            <div class="card-header bg-secondary text-white">
                Extrato de Pagamento de Afiliados
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-striped table-hover mb-0">
                        <thead class="table-dark">
                            <tr>
                                <th>ID</th>
                                <th>Cliente</th>
                                <th>Valor</th>
                                <th>Data</th>
                                <th>Descrição</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($extratos as $e): ?>
                                <tr>
                                    <td><?= $e['id'] ?></td>
                                    <td><?= htmlspecialchars($e['cliente']) ?></td>
                                    <td><?= formatValor($e['valor']) ?></td>
                                    <td><?= formatData($e['data']) ?></td>
                                    <td><?= htmlspecialchars($e['descricao']) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Faturamentos -->
        <div class="card mb-4 shadow-sm">
            <div class="card-header bg-dark text-white">
                Faturamentos Recentes
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-striped table-hover mb-0">
                        <thead class="table-dark">
                            <tr>
                                <th>ID</th>
                                <th>Valor Faturado</th>
                                <th>Data Vencimento</th>
                                <th>Total Cobranças</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($faturamentos as $f): ?>
                                <tr>
                                    <td><?= $f['id'] ?></td>
                                    <td><?= formatValor($f['valor_faturado']) ?></td>
                                    <td><?= formatData($f['data_vencimento']) ?></td>
                                    <td><?= $f['total_cobrancas'] ?? '-' ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</body>

</html>