<?php
class Sql
{
    private $conn;
    private $user = "maverp";
    private $pass = "ddd001";

    public function __construct()
    {
        $this->conn = new PDO(
            'pgsql:host=127.0.0.1;port=5433;dbname=maverp', // porta ajustada
            $this->user,
            $this->pass,
            [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
        );

        // UTF-8 é padrão no PostgreSQL, mas não atrapalha
        $this->conn->exec("SET client_encoding TO 'UTF8'");
    }

    public function query($rawQuery, $params = array())
    {
        $stmt = $this->conn->prepare($rawQuery);

        foreach ($params as $key => $value) {
            $stmt->bindValue($key, $value);
        }

        $stmt->execute();
        return $stmt;
    }

    public function rowquery($rawQuery, $params = array())
    {
        $stmt = $this->query($rawQuery, $params);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}

try {
    $db = new Sql();
    echo "Conexão via túnel OK!<br><br>";

    $clientes = $db->rowquery("SELECT nome, cpf_cnpj, status FROM clientes LIMIT 5");
    echo "<pre>";
    print_r($clientes);
    echo "</pre>";
} catch (PDOException $e) {
    echo "Erro: " . $e->getMessage();
}
