<?php
// add_subaccount.php
header('Content-Type: application/json');

// Coloque sua chave de API do SMTP2GO aqui
$API_KEY = 'api-6FD2EBA86CC9401AB64F67723212FD98';

// Lê os dados enviados via POST
$input = json_decode(file_get_contents('php://input'), true);

if (!$input || !isset($input['fullname']) || !isset($input['limit'])) {
    echo json_encode(['error' => 'Dados incompletos']);
    http_response_code(400);
    exit;
}

$fullname = $input['fullname'];
$limit = (int)$input['limit'];

// Monta o payload para a API SMTP2GO
$payload = [
    'fullname' => $fullname,
    'limit' => $limit,
    'dedicated_ip' => false,
    'archiving' => false,
    'enforce_2fa' => false,
    'enable_sms' => false,
    'sms_limit' => 1000
];

// Inicializa o cURL
$ch = curl_init('https://api.smtp2go.com/v3/subaccount/add');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'X-Smtp2go-Api-Key: ' . $API_KEY
]);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

if (curl_errno($ch)) {
    echo json_encode(['error' => curl_error($ch)]);
    http_response_code(500);
    exit;
}

curl_close($ch);

// Retorna a resposta da API
if ($http_code === 200) {
    echo $response; // sucesso
} else {
    // Em caso de erro, retorna a mensagem da API
    echo $response;
    http_response_code($http_code);
}
