<?php
// edit_subaccount.php
header('Content-Type: application/json');
$data = json_decode(file_get_contents('php://input'), true);

if (!$data['id'] || !$data['fullname'] || !$data['limit']) {
    echo json_encode(['error' => 'Parâmetros inválidos']);
    http_response_code(400);
    exit;
}

$apiKey = 'api-6FD2EBA86CC9401AB64F67723212FD98';
$body = [
    'id' => $data['id'],
    'fullname' => $data['fullname'],
    'limit' => (int)$data['limit'],
    'dedicated_ip' => false,
    'archiving' => false,
    'enforce_2fa' => false,
    'enable_sms' => false,
    'sms_limit' => 1000
];

$ch = curl_init("https://api.smtp2go.com/v3/subaccount/edit"); 
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'X-Smtp2go-Api-Key: ' . $apiKey
]);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($body));

$response = curl_exec($ch);
$err = curl_error($ch);
curl_close($ch);

if ($err) {
    echo json_encode(['error' => $err]);
    http_response_code(500);
} else {
    echo $response;
}
