<?php
// fetch_client_users.php
header('Content-Type: application/json; charset=utf-8');

if (!isset($_GET['subaccount_id']) || empty($_GET['subaccount_id'])) {
    echo json_encode(['error' => 'Parâmetro subaccount_id é obrigatório']);
    exit;
}

$subaccount_id = $_GET['subaccount_id'];
$api_key = 'api-6FD2EBA86CC9401AB64F67723212FD98';

$url = 'https://api.smtp2go.com/v3/users/smtp/view';

$payload = json_encode(['subaccount_id' => $subaccount_id]);

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'X-Smtp2go-Api-Key: ' . $api_key,
    'accept: application/json'
]);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);

$response = curl_exec($ch);

if ($response === false) {
    echo json_encode(['error' => 'Erro cURL: ' . curl_error($ch)]);
    curl_close($ch);
    exit;
}

$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpcode !== 200) {
    echo json_encode(['error' => "API retornou HTTP $httpcode"]);
    exit;
}

$responseData = json_decode($response, true);

if (!$responseData || !isset($responseData["data"]["results"])) {
    echo json_encode(['error' => 'Resposta inválida da API SMTP2GO']);
    exit;
}

$users = $responseData["data"]["results"];

// Vamos simplificar e enviar só os campos necessários para o front-end
$result = [];
foreach ($users as $user) {
    $result[] = [
    "username" => $user["username"] ?? "",
    "email_password" => $user["email_password"] ?? "", // <--- adiciona isso
    "status" => $user["status"] ?? "",
    "sending_allowed" => $user["sending_allowed"] ?? true
];

}

echo json_encode($result);
exit;
