<?php
//session_start();

//if (!isset($_SESSION['user_id'])) {
//    header("Location: login.php");
//    exit;
//}

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

define('API_KEY', 'api-6FD2EBA86CC9401AB64F67723212FD98');

// Endpoint para buscar bounces pelo ID da subconta (AJAX)
if (isset($_GET['bounces']) && $_GET['bounces'] === '1' && isset($_GET['id'])) {
    $id = intval($_GET['id']);
    if ($id <= 0) {
        http_response_code(400);
        echo json_encode(['error' => 'ID inválido']);
        exit;
    }
    $url = "https://api.smtp2go.com/v3/stats/email_bounces";
    $payload = ['id' => $id];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "accept: application/json",
        "Content-Type: application/json",
        "X-Smtp2go-Api-Key: " . API_KEY
    ]);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

    $response = curl_exec($ch);
    if ($response === false) {
        $err = curl_error($ch);
        curl_close($ch);
        http_response_code(500);
        echo json_encode(['error' => "Erro cURL: $err"]);
        exit;
    }

    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpcode !== 200) {
        http_response_code($httpcode);
        echo json_encode(['error' => 'Erro na API ao buscar bounces']);
        exit;
    }

    $data = json_decode($response, true);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['usage' => $data['data'] ?? []]);
    exit;
}

// Endpoint para listar todas subcontas em JSON (AJAX)
function fetch_all_subaccounts()
{
    $url = "https://api.smtp2go.com/v3/subaccounts/search";

    $all_subaccounts = [];
    $continue_token = null;

    do {
        $payload = [
            "fuzzy_search" => true,
            "states" => "all",
            "sort_direction" => "asc",
            "page_size" => 100
        ];
        if ($continue_token) {
            $payload["continue_token"] = $continue_token;
        }

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "accept: application/json",
            "Content-Type: application/json",
            "X-Smtp2go-Api-Key: " . API_KEY
        ]);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

        $response = curl_exec($ch);
        if ($response === false) {
            $err = curl_error($ch);
            curl_close($ch);
            throw new Exception("Erro na requisição cURL: $err");
        }
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($httpcode !== 200) {
            throw new Exception("Erro na API SMTP2GO: HTTP $httpcode, resposta: $response");
        }

        $data = json_decode($response, true);
        if (!$data || !isset($data["data"])) {
            throw new Exception("Resposta inválida da API");
        }

        $subaccounts = $data["data"]["subaccounts"] ?? [];
        $continue_token = $data["data"]["continue_token"] ?? null;

        $all_subaccounts = array_merge($all_subaccounts, $subaccounts);
    } while ($continue_token);

    return $all_subaccounts;
}

if (isset($_GET['json']) && $_GET['json'] === '1') {
    try {
        $subs = fetch_all_subaccounts();
        $result = [];
        foreach ($subs as $sub) {
            $result[] = [
                "id" => $sub["id"] ?? "",
                "name" => $sub["name"] ?? "",
                "plan_size" => $sub["plan_size"] ?? "",
                "plan_used" => $sub["plan_used"] ?? "",
                "plan_remaining" => $sub["plan_remaining"] ?? "",
                "state" => strtolower($sub["state"] ?? "")
            ];
        }
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode(["subaccounts" => $result]);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(["error" => $e->getMessage()]);
    }
    exit;
}
?>

<!DOCTYPE html>
<html lang="pt-BR" class="h-100">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Monitor SMTP2GO</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <style>
        body,
        html {
            height: 100%;
            margin: 0;
            background: #f0f2f5;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            width: 220px;
            height: 100%;
            background-color: #16396d;
            color: #fff;
            padding-top: 1rem;
            box-shadow: 2px 0 5px rgba(0, 0, 0, 0.1);
            z-index: 1000;
        }

        .sidebar h2 {
            font-weight: 700;
            font-size: 1.5rem;
            text-align: center;
            margin-bottom: 2rem;
            letter-spacing: 2px;
        }

        .sidebar nav a {
            display: block;
            color: #cdd9f4;
            padding: 0.75rem 1.5rem;
            text-decoration: none;
            font-weight: 600;
            transition: background-color 0.3s ease, color 0.3s ease;
            border-left: 4px solid transparent;
        }

        .sidebar nav a.active,
        .sidebar nav a:hover {
            background-color: #1e3c72;
            color: #fff;
            border-left: 4px solid #ffdd57;
        }

        main {
            margin-left: 220px;
            padding: 2rem 2.5rem;
            min-height: 100vh;
            background: #fff;
            box-shadow: 0 0 15px rgb(0 0 0 / 0.1);
            border-radius: 8px;
            margin-top: 20px;
            margin-bottom: 20px;
        }

        h1 {
            font-weight: 700;
            color: #16396d;
            margin-bottom: 1.5rem;
            font-size: 1.8rem;
        }

        .table-compact {
            font-size: 0.85rem;
        }

        .table-compact th,
        .table-compact td {
            padding: 0.4rem 0.6rem;
            vertical-align: middle;
        }

        .btn-sm {
            font-size: 0.8rem;
            padding: 0.25rem 0.6rem;
        }

        .btn-icon {
            cursor: pointer;
            color: #dc3545;
            font-size: 1.1rem;
            user-select: none;
        }

        .btn-icon.disabled {
            position: relative;
        }


        /* Form add/remove container */
        .form-container {
            max-width: 480px;
            background: #f7f9fc;
            border-radius: 8px;
            padding: 1.25rem 1.5rem;
            box-shadow: 0 0 10px rgb(0 0 0 / 0.05);
            margin-top: 1rem;
        }

        .form-container h3 {
            margin-bottom: 1rem;
            color: #16396d;
        }

        .form-container label {
            font-weight: 600;
            color: #16396d;
        }

        .text-muted-small {
            font-size: 0.8rem;
            color: #6c757d;
        }

        .btn-icon.disabled {
            opacity: 0.5;
            pointer-events: none;
            position: relative;
            /* precisa estar aqui para o overlay */
        }

        .btn-icon .x-overlay {
            position: absolute;
            top: -5px;
            right: -5px;
            font-size: 0.7em;
            color: red;
        }
    </style>
</head>

<body>

    <!-- Toast global/alerta flutuante -->
    <div id="alertMessage" class="alert position-fixed top-0 end-0 m-3 d-none" role="alert"></div>

    <aside class="sidebar">
        <h2>SMTP Monitor</h2>
        <nav>
            <a href="#" class="nav-link active" data-page="dashboard">Resumo</a>
            <a href="#" class="nav-link" data-page="bounceReport">Relatório de Bounces</a>
            <a href="logout.php" class="nav-link">Sair</a>
        </nav>
    </aside>

    <main>
        <!-- Página de resumo -->
        <section id="page-dashboard" class="page active">
            <h1>Resumo de Contas SMTP2GO</h1>
            <div class="d-flex align-items-center mb-3 gap-2 flex-wrap">
                <input type="text" id="searchInput" placeholder="Pesquisar cliente..."
                    class="form-control" style="max-width: 300px; flex-grow:1;">

                <div class="dropdown">
                    <button class="btn btn-outline-primary dropdown-toggle" type="button"
                        id="filterDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                        All
                    </button>
                    <ul class="dropdown-menu" aria-labelledby="filterDropdown" id="subaccountsFilter">
                        <li><a class="dropdown-item" href="#" data-state="all">All</a></li>
                        <li><a class="dropdown-item" href="#" data-state="active">Active</a></li>
                        <li><a class="dropdown-item" href="#" data-state="suspended">Suspended</a></li>
                        <li><a class="dropdown-item" href="#" data-state="closed">Closed</a></li>
                    </ul>
                </div>

                <!-- Botão de adicionar conta -->
                <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addAccountModal">
                    + Adicionar Conta
                </button>
            </div>

            <div class="table-responsive">
                <table class="table table-striped table-hover table-compact">
                    <thead class="table-light">
                        <tr>
                            <th>Nome</th>
                            <th>Plano (Total)</th>
                            <th>Usados</th>
                            <th>Restantes</th>
                            <th>Status</th>
                            <th></th> <!-- coluna para ações -->
                        </tr>
                    </thead>
                    <tbody id="accountsTableBody">
                        <tr>
                            <td colspan="6" class="text-center text-muted">Carregando...</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <!-- Mensagens de feedback -->
            <div id="editMessage" class="mt-3 text-center fw-bold"></div>
        </section>


        <!-- Nova página de Relatório de Bounces -->
        <section id="page-bounceReport" class="page" style="display:none;">
            <h1>Relatório de Subcontas com Bounces Altos</h1>
            <div class="table-responsive">
                <table class="table table-striped table-hover table-compact">
                    <thead class="table-light">
                        <tr>
                            <th>Subconta</th>
                            <th>Total Envio</th>
                            <th>Rejeições (Bounces)</th>
                            <th>Soft Bounces</th>
                            <th>Hard Bounces</th>
                            <th>% Rejeição</th>
                        </tr>
                    </thead>
                    <tbody id="bounceReportTableBody">
                        <tr>
                            <td colspan="6" class="text-center text-muted">Carregando relatório...</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </section>

        <!-- Modal para adicionar conta -->
        <div class="modal fade" id="addAccountModal" tabindex="-1" aria-labelledby="addAccountModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">

                    <div class="modal-header">
                        <h5 class="modal-title" id="addAccountModalLabel">Adicionar Subconta</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
                    </div>

                    <div class="modal-body">
                        <form id="addAccountForm">
                            <div class="mb-3">
                                <label for="addFullName" class="form-label">Nome completo da subconta</label>
                                <input type="text" class="form-control" id="addFullName" required placeholder="Exemplo: Cliente XYZ">
                            </div>
                            <div class="mb-3">
                                <label for="addLimit" class="form-label">Limite de envios</label>
                                <select id="addLimit" class="form-select" required>
                                    <option value="2000">2.000</option>
                                    <option value="5000">5.000</option>
                                    <option value="10000" selected>10.000</option>
                                    <option value="20000">20.000</option>
                                    <option value="40000">40.000</option>
                                    <option value="60000">60.000</option>
                                    <option value="80000">80.000</option>
                                    <option value="100000">100.000</option>
                                </select>
                            </div>
                            <div id="addAccountMessage" class="mt-3"></div>
                        </form>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" form="addAccountForm" class="btn btn-success btn-sm">Adicionar</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal para editar subconta -->
        <!-- Modal de edição -->
        <div class="modal fade" id="editSubaccountModal" tabindex="-1" aria-labelledby="editSubaccountModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">

                    <div class="modal-header">
                        <h5 class="modal-title" id="editSubaccountModalLabel">Editar Subconta</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
                    </div>

                    <div class="modal-body">
                        <form id="editSubaccountForm">
                            <input type="hidden" id="editSubaccountId">
                            <div class="mb-3">
                                <label for="editFullname" class="form-label">Nome completo da subconta</label>
                                <input type="text" class="form-control" id="editFullname" required>
                            </div>
                            <div class="mb-3">
                                <label for="editLimit" class="form-label">Limite de envios</label>
                                <select id="editLimit" class="form-select" required>
                                    <option value="2000">2.000</option>
                                    <option value="5000">5.000</option>
                                    <option value="10000">10.000</option>
                                    <option value="20000">20.000</option>
                                    <option value="40000">40.000</option>
                                    <option value="60000">60.000</option>
                                    <option value="80000">80.000</option>
                                    <option value="100000">100.000</option>
                                    <option value="250000">250.000</option>
                                    <option value="500000">500.000</option>
                                </select>
                            </div>
                            <div id="editAccountMessage" class="mt-3"></div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Cancelar</button>
                                <button type="submit" class="btn btn-success btn-sm">Salvar</button>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>

    </main>



    <!-- Modal Bootstrap para detalhes da subconta -->
    <div class="modal fade" id="bounceModal" tabindex="-1" aria-labelledby="bounceModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="bounceModalLabel">Detalhes da Subconta</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
                </div>
                <div class="modal-body">
                    <p><strong>Nome:</strong> <span id="modalSubaccountName"></span></p>
                    <p><strong>Total de Envios:</strong> <span id="modalTotalSends"></span></p>
                    <p><strong>Rejeições (Bounces):</strong> <span id="modalTotalBounces"></span></p>
                    <p><strong>Soft Bounces:</strong> <span id="modalSoftBounces"></span></p>
                    <p><strong>Hard Bounces:</strong> <span id="modalHardBounces"></span></p>
                    <div id="modalError" class="text-danger" style="display:none;"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Fechar</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Controle de páginas do menu lateral
        const links = document.querySelectorAll('.sidebar nav a.nav-link');
        const pages = document.querySelectorAll('main section.page');

        links.forEach(link => {
            link.addEventListener('click', e => {
                e.preventDefault();
                links.forEach(l => l.classList.remove('active'));
                link.classList.add('active');

                const page = link.dataset.page;
                pages.forEach(p => {
                    const isCurrent = p.id === 'page-' + page;
                    p.style.display = isCurrent ? 'block' : 'none';
                    p.classList.toggle('active', isCurrent);
                });

                // Se for a página de relatório de bounces, carrega os dados
                if (page === 'bounceReport') loadBounceReport();
            });
        });


        // Inicializa modal de edição
        const editModal = new bootstrap.Modal(document.getElementById('editSubaccountModal'));

        // Busca todas as subcontas da API
        async function fetchSubaccounts() {
            const response = await fetch('?json=1');
            if (!response.ok) throw new Error('Falha ao buscar dados');
            const data = await response.json();
            if (data.error) throw new Error(data.error);
            return data.subaccounts;
        }

        // Renderiza tabela de subcontas
        function renderTable(accounts) {
            const tbody = document.getElementById('accountsTableBody');
            if (!accounts.length) {
                tbody.innerHTML = '<tr><td colspan="6" class="text-center fst-italic text-muted">Nenhuma conta encontrada.</td></tr>';
                return;
            }

            tbody.innerHTML = accounts.map(acc => `
            <tr>
                <td><a href="#" class="subaccount-link" data-id="${acc.id}" data-name="${acc.name}">${acc.name}</a></td>
                <td>${acc.plan_size}</td>
                <td>${acc.plan_used}</td>
                <td>${acc.plan_remaining}</td>
                <td>
                    <span class="badge ${acc.state === 'active' ? 'bg-success' : acc.state === 'closed' ? 'bg-danger' : 'bg-secondary'}">
                        ${acc.state.charAt(0).toUpperCase() + acc.state.slice(1)}
                    </span>
                </td>
                <td class="d-flex gap-2">
                    ${acc.state === 'active'
                        ? `<span title="Fechar subconta" class="btn-close-sub btn-icon" data-id="${acc.id}" data-name="${acc.name}">&#128465;</span>`
                        : `<span title="Subconta não ativa" class="btn-icon disabled position-relative">&#128465;<span class="x-overlay">&#10060;</span></span>`}
                    
                    <span title="Editar subconta" class="btn-edit-sub btn-icon" data-id="${acc.id}" data-name="${acc.name}" data-fullname="${acc.name}" data-limit="${acc.plan_size}">&#9998;</span> 

                    ${acc.state === 'closed'
                        ? `<span title="Reabrir subconta" class="btn-reopen btn-icon" data-id="${acc.id}" data-name="${acc.name}">&#128257;</span>`
                        : ''}
                </td>
            </tr>
        `).join('');
        }

        // Filtro por nome
        function filterAccounts(query, accounts) {
            if (!query) return accounts;
            query = query.toLowerCase();
            return accounts.filter(acc => acc.name.toLowerCase().includes(query));
        }

        // Filtro por estado
        function filterByState(accounts, state) {
            if (state === 'all') return accounts;
            return accounts.filter(acc => acc.state.toLowerCase() === state);
        }

        let currentFilter = 'all';
        const searchInput = document.getElementById('searchInput');

        // Carrega e renderiza dashboard
        async function loadDashboard() {
            const tbody = document.getElementById('accountsTableBody');
            tbody.innerHTML = '<tr><td colspan="6" class="text-center">Carregando...</td></tr>';
            try {
                const accounts = await fetchSubaccounts();
                window.accountsCache = accounts;
                const filteredBySearch = filterAccounts(searchInput.value.trim(), accounts);
                const finalFiltered = filterByState(filteredBySearch, currentFilter);
                renderTable(finalFiltered);
            } catch (err) {
                tbody.innerHTML = `<tr><td colspan="6" class="text-center text-danger">Erro ao carregar dados: ${err.message}</td></tr>`;
            }
        }

        // Dropdown de filtro
        document.querySelectorAll('#subaccountsFilter a').forEach(a => {
            a.addEventListener('click', e => {
                e.preventDefault();
                currentFilter = a.dataset.state;
                document.getElementById('filterDropdown').textContent = a.textContent;
                const filteredBySearch = filterAccounts(searchInput.value.trim(), window.accountsCache || []);
                const finalFiltered = filterByState(filteredBySearch, currentFilter);
                renderTable(finalFiltered);
            });
        });

        // Filtro por pesquisa
        searchInput.addEventListener('input', () => {
            const filteredBySearch = filterAccounts(searchInput.value.trim(), window.accountsCache || []);
            const finalFiltered = filterByState(filteredBySearch, currentFilter);
            renderTable(finalFiltered);
        });

        // Delegação: ações da tabela
        document.getElementById('accountsTableBody').addEventListener('click', async e => {
            const el = e.target;
            const tr = el.closest('tr');

            // Expandir usuários SMTP
            if (el.classList.contains('subaccount-link')) {
                e.preventDefault();
                const id = el.dataset.id;
                const name = el.dataset.name;

                if (tr.nextElementSibling && tr.nextElementSibling.classList.contains('smtp-details-row')) {
                    tr.nextElementSibling.remove();
                    return;
                }

                const loadingRow = document.createElement('tr');
                loadingRow.classList.add('smtp-details-row');
                loadingRow.innerHTML = `<td colspan="6" class="text-center text-muted">Carregando dados SMTP...</td>`;
                tr.insertAdjacentElement('afterend', loadingRow);

                try {
                    const response = await fetch(`get_smtp_users.php?id=${encodeURIComponent(id)}`);
                    const users = await response.json();

                    if (!Array.isArray(users) || !users.length) {
                        loadingRow.innerHTML = `<td colspan="6" class="text-center text-muted">Nenhum usuário SMTP encontrado.</td>`;
                        return;
                    }

                    for (let user of users) {
                        try {
                            const bounceResp = await fetch(`get_bounces.php?email=${encodeURIComponent(user.username)}`);
                            const bounceData = await bounceResp.json();
                            user.rejects = bounceData.data?.rejects || 0;
                            user.softbounces = bounceData.data?.softbounces || 0;
                            user.hardbounces = bounceData.data?.hardbounces || 0;
                        } catch {
                            user.rejects = 0;
                            user.softbounces = 0;
                            user.hardbounces = 0;
                        }
                    }

                    let html = `<td colspan="6">
                    <strong>Usuários SMTP da subconta "${name}":</strong>
                    <table class="table table-sm mt-2">
                        <thead>
                            <tr>
                                <th>E-mail</th>
                                <th>Senha</th>
                                <th>Rejeitados</th>
                                <th>Soft Bounces</th>
                                <th>Hard Bounces</th>
                            </tr>
                        </thead>
                        <tbody>
                            ${users.map(u => `
                                <tr>
                                    <td>${u.username}</td>
                                    <td><code>${u.email_password}</code></td>
                                    <td>${u.rejects}</td>
                                    <td>${u.softbounces}</td>
                                    <td>${u.hardbounces}</td>
                                </tr>`).join('')}
                        </tbody>
                    </table>
                </td>`;

                    loadingRow.innerHTML = html;
                } catch (err) {
                    loadingRow.innerHTML = `<td colspan="6" class="text-danger text-center">Erro: ${err.message}</td>`;
                }
            }

            // Fechar subconta
            if (el.classList.contains('btn-close-sub')) {
                const id = el.dataset.id;
                const name = el.dataset.name;
                if (!confirm(`Tem certeza que deseja fechar a subconta "${name}"?`)) return;
                try {
                    const response = await fetch('close_subaccount.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify({
                            id
                        })
                    });
                    const data = await response.json();
                    if (response.ok) loadDashboard();
                    else alert('Erro: ' + (data.error || 'Desconhecido'));
                } catch (err) {
                    alert(err.message);
                }
            }

            // Reabrir subconta
            if (el.classList.contains('btn-reopen')) {
                const id = el.dataset.id;
                if (!confirm(`Deseja reabrir a subconta "${el.dataset.name}"?`)) return;
                try {
                    const res = await fetch('reopen_subaccount.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify({
                            id
                        })
                    });
                    const data = await res.json();
                    if (res.ok) loadDashboard();
                    else alert('Erro: ' + (data.error || 'Desconhecido'));
                } catch (err) {
                    alert(err.message);
                }
            }

            // Editar subconta
            if (el.classList.contains('btn-edit-sub')) {
                const id = el.dataset.id;
                const fullname = el.dataset.fullname;
                const limit = el.dataset.limit;

                document.getElementById('editSubaccountId').value = id;
                document.getElementById('editFullname').value = fullname;
                document.getElementById('editLimit').value = limit;

                editModal.show();
            }
        });

        // Adicionar subconta
        document.getElementById('addAccountForm').addEventListener('submit', async e => {
            e.preventDefault();
            const fullname = document.getElementById('addFullName').value;
            const limit = parseInt(document.getElementById('addLimit').value);
            const messageDiv = document.getElementById('addAccountMessage');
            messageDiv.textContent = 'Adicionando subconta...';

            try {
                const res = await fetch('add_subaccount.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        fullname,
                        limit
                    })
                });
                const data = await res.json();
                if (res.ok) {
                    messageDiv.textContent = 'Subconta adicionada com sucesso!';
                    e.target.reset();
                    loadDashboard();
                } else messageDiv.textContent = 'Erro: ' + (data.error || JSON.stringify(data));
            } catch (err) {
                messageDiv.textContent = 'Erro: ' + err.message;
            }
        });

        // Editar subconta
        // Valores permitidos
        const allowedLimits = [2000, 5000, 10000, 20000, 40000, 60000, 80000, 100000, 250000, 500000];

        // Editar subconta (com validação e mensagens no modal)
        document.getElementById('editSubaccountForm').addEventListener('submit', async e => {
            e.preventDefault();
            const id = document.getElementById('editSubaccountId').value;
            const fullname = document.getElementById('editFullname').value;
            const limit = parseInt(document.getElementById('editLimit').value);
            const msg = document.getElementById('editMessage'); // <div id="editMessage"></div> no modal

            msg.textContent = "";

            // Validação
            if (!allowedLimits.includes(limit)) {
                msg.textContent = "❌ Limite inválido. Use apenas: " + allowedLimits.join(", ");
                msg.className = "text-danger";
                return;
            }

            const submitButton = e.target.querySelector('button[type="submit"]');
            const originalText = submitButton.textContent;

            try {
                // Mostra que está carregando
                submitButton.disabled = true;
                submitButton.textContent = "Salvando... ⏳";

                const res = await fetch('edit_subaccount.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        id,
                        fullname,
                        limit
                    })
                });
                const data = await res.json();

                if (res.ok && data.data) {
                    showMessage("✅ Subconta atualizada com sucesso!", "success");

                    setTimeout(() => {
                        editModal.hide();
                        loadDashboard();
                    }, 1500);
                } else {
                    showMessage("❌ Erro: " + (data.error || JSON.stringify(data)), "danger");
                }
            } catch (err) {
                showMessage("❌ Erro: " + err.message, "danger");
            } finally {
                // Restaura o botão
                submitButton.disabled = false;
                submitButton.textContent = originalText;
            }
        });


        function showMessage(msg, type = 'success') {
            const alertDiv = document.getElementById('alertMessage');
            alertDiv.textContent = msg;
            alertDiv.className = `alert alert-${type} position-fixed top-0 end-0 m-3`;
            alertDiv.classList.remove('d-none');
            setTimeout(() => {
                alertDiv.classList.add('d-none');
            }, 3000);
        }


        // Inicializa dashboard
        loadDashboard();
    </script>



</body>

</html>