<?php
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

define('API_KEY', 'api-6FD2EBA86CC9401AB64F67723212FD98');

function fetch_all_subaccounts()
{
    $url = "https://api.smtp2go.com/v3/subaccounts/search";

    $all_subaccounts = [];
    $continue_token = null;

    do {
        $payload = [
            "fuzzy_search" => true,
            "states" => "all",
            "sort_direction" => "asc",
            "page_size" => 100
        ];
        if ($continue_token) {
            $payload["continue_token"] = $continue_token;
        }

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "accept: application/json",
            "Content-Type: application/json",
            "X-Smtp2go-Api-Key: " . API_KEY
        ]);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

        $response = curl_exec($ch);
        if ($response === false) {
            $err = curl_error($ch);
            curl_close($ch);
            throw new Exception("Erro na requisição cURL: $err");
        }
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($httpcode !== 200) {
            throw new Exception("Erro na API SMTP2GO: HTTP $httpcode, resposta: $response");
        }

        $data = json_decode($response, true);
        if (!$data || !isset($data["data"])) {
            throw new Exception("Resposta inválida da API");
        }

        $subaccounts = $data["data"]["subaccounts"] ?? [];
        $continue_token = $data["data"]["continue_token"] ?? null;

        $all_subaccounts = array_merge($all_subaccounts, $subaccounts);
    } while ($continue_token);

    return $all_subaccounts;
}

if (isset($_GET['json']) && $_GET['json'] === '1') {
    try {
        $subs = fetch_all_subaccounts();
        $result = [];
        foreach ($subs as $sub) {
            $result[] = [
                "id" => $sub["id"] ?? "",      // <-- adicione aqui
                "name" => $sub["name"] ?? "",
                "plan_size" => $sub["plan_size"] ?? "",
                "plan_used" => $sub["plan_used"] ?? "",
                "plan_remaining" => $sub["plan_remaining"] ?? "",
                "state" => strtolower($sub["state"] ?? "")
            ];
        }
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode(["subaccounts" => $result]);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(["error" => $e->getMessage()]);
    }
    exit;
}

if (isset($_GET['download']) && $_GET['download'] === 'csv') {
    try {
        $subs = fetch_all_subaccounts();

        $fields = [
            "name" => "Nome",
            "plan_size" => "Plano (Total de envios)",
            "plan_used" => "Envios usados",
            "plan_remaining" => "Envios restantes",
            "state" => "Estado da conta"
        ];

        header('Content-Type: text/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename=subcontas_resumido.csv');

        $output = fopen('php://output', 'w');
        fputcsv($output, array_values($fields));

        foreach ($subs as $sub) {
            $row = [];
            foreach ($fields as $key => $label) {
                $val = $sub[$key] ?? '';
                if ($key === 'state') {
                    $val = ucfirst(strtolower($val));
                }
                $row[] = $val;
            }
            fputcsv($output, $row);
        }

        fclose($output);
        exit;
    } catch (Exception $e) {
        http_response_code(500);
        echo "Erro ao gerar CSV: " . htmlspecialchars($e->getMessage());
    }
    exit;
}
?>

<!DOCTYPE html>
<html lang="pt-BR" class="h-100">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Relatório SMTP2GO</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <style>
        body,
        html {
            height: 100%;
            background: linear-gradient(135deg, #1e3c72, #2a5298);
            color: #fff;
        }

        .navbar-custom {
            background-color: #16396d;
        }

        .container-main {
            max-width: 1000px;
            margin-top: 90px;
            margin-bottom: 30px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 12px;
            padding: 1.5rem 2rem;
            box-shadow: 0 8px 24px rgb(0 0 0 / 0.3);
            backdrop-filter: blur(6px);
            color: #fff;
        }

        .form-control {
            background: rgba(255, 255, 255, 0.15);
            border: none;
            color: #fff;
        }

        .form-control::placeholder {
            color: #d0d7e3;
        }

        .form-control:focus {
            background: rgba(255, 255, 255, 0.3);
            color: #000;
            box-shadow: none;
        }

        .table thead th {
            border-bottom: 2px solid #0a2b5e;
        }

        .table-striped>tbody>tr:nth-of-type(odd) {
            background-color: rgba(255, 255, 255, 0.08);
        }

        .badge-state {
            font-weight: 600;
            font-size: 0.9rem;
        }
    </style>
</head>

<body class="d-flex flex-column h-100">

    <nav class="navbar navbar-expand-lg navbar-custom fixed-top shadow">
        <div class="container">
            <a class="navbar-brand text-white fw-bold" href="#">Monitor SMTP</a>
            <form class="d-flex w-50" role="search" onsubmit="return false;">
                <input class="form-control me-2" type="search" placeholder="Pesquisar cliente..." aria-label="Pesquisar" id="searchInput" />
            </form>
            <div>
                <a href="logout.php" class="btn btn-outline-light">Sair</a>
                <a href="?download=csv" class="btn btn-primary ms-2">Baixar CSV</a>
            </div>
        </div>
    </nav>

    <main class="container container-main shadow">
        <h1 class="mb-4 text-center">Relatório de Contas SMTP2GO</h1>

        <div class="table-responsive rounded shadow-sm">
            <table class="table table-hover table-striped align-middle text-white">
                <thead class="table-dark">
                    <tr>
                        <th>Nome</th>
                        <th>Plano (Total de envios)</th>
                        <th>Envios usados</th>
                        <th>Envios restantes</th>
                        <th>Estado da conta</th>

                    </tr>
                </thead>
                <tbody id="accountsTableBody">
                    <tr>
                        <td colspan="5" class="text-center text-muted">Carregando...</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </main>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        const tableBody = document.getElementById('accountsTableBody');
        const searchInput = document.getElementById('searchInput');
        let accounts = [];

        function renderTable(filteredAccounts) {
            if (filteredAccounts.length === 0) {
                tableBody.innerHTML = '<tr><td colspan="5" class="text-center fst-italic text-muted">Nenhuma conta encontrada.</td></tr>';
                return;
            }

            tableBody.innerHTML = filteredAccounts.map(acc => `
      <tr class="client-row" data-id="${acc.id}">
        <td>${acc.name}</td>
        <td>${acc.plan_size}</td>
        <td>${acc.plan_used}</td>
        <td>${acc.plan_remaining}</td>
        <td>
          <span class="badge badge-state ${acc.state === 'active' ? 'bg-success' : 'bg-secondary'}">
            ${acc.state.charAt(0).toUpperCase() + acc.state.slice(1)}
          </span>
        </td>
      </tr>
      <tr class="client-details-row" style="display:none;">
        <td colspan="5">
          <div class="client-details p-3 bg-light text-dark rounded">
            Carregando usuários...
          </div>
        </td>
      </tr>
    `).join('');

            // Adicionar evento de clique nas linhas de cliente
            document.querySelectorAll('.client-row').forEach(row => {
                row.addEventListener('click', () => {
                    const detailsRow = row.nextElementSibling;
                    if (detailsRow.style.display === 'table-row') {
                        detailsRow.style.display = 'none';
                    } else {
                        // Fecha outras linhas abertas
                        document.querySelectorAll('.client-details-row').forEach(r => r.style.display = 'none');
                        detailsRow.style.display = 'table-row';
                        loadClientDetails(row.dataset.id, detailsRow.querySelector('.client-details'));
                    }
                });
            });
        }

        // Função para buscar bounce de um e-mail via seu PHP proxy
        async function fetchBounceData(email) {
            try {
                const response = await fetch('fetch_email_bounces.php?username=' + encodeURIComponent(email));
                if (!response.ok) throw new Error('Erro ao buscar dados de bounce para ' + email);
                const data = await response.json();
                return data.data || null;
            } catch (err) {
                console.error('Erro fetchBounceData:', err);
                return null;
            }
        }

        async function loadClientDetails(subaccountId, container) {
            container.innerHTML = "Carregando usuários...";

            // Função auxiliar para buscar os dados totais da subconta
            async function fetchSubaccountSummary(subaccountId) {
                const apiKey = 'api-6FD2EBA86CC9401AB64F67723212FD98';
                const url = 'https://api.smtp2go.com/v3/stats/subaccount_summary';
                const payload = {
                    subaccount_id: subaccountId
                };

                try {
                    const response = await fetch(url, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-Smtp2go-Api-Key': apiKey,
                            'accept': 'application/json'
                        },
                        body: JSON.stringify(payload)
                    });
                    if (!response.ok) throw new Error('Erro ao buscar resumo da subconta');
                    const data = await response.json();
                    return data.data || null;
                } catch (err) {
                    console.error('Erro fetchSubaccountSummary:', err);
                    return null;
                }
            }

            try {
                const response = await fetch('fetch_client_users.php?subaccount_id=' + encodeURIComponent(subaccountId));
                if (!response.ok) throw new Error('Falha ao carregar usuários');
                const users = await response.json();

                if (!Array.isArray(users) || users.length === 0) {
                    container.innerHTML = `<div class="text-muted fst-italic">Nenhum usuário SMTP encontrado para este cliente.</div>`;
                    return;
                }

                // Busca os totais da subconta antes de renderizar
                const subaccountSummary = await fetchSubaccountSummary(subaccountId);
                // Garante que pega os campos certos da API e evita NaN
                const totalRejects = Number(subaccountSummary?.rejects ?? 0);
                const totalEmails = Number(
                    subaccountSummary?.emails ??
                    subaccountSummary?.sent ?? // se a API usar "sent" em vez de "emails"
                    0
                );

                const bouncePercentTotal = totalEmails > 0 ?
                    ((totalRejects / totalEmails) * 100).toFixed(2) :
                    '0.00';


                // PAGINAÇÃO
                const pageSize = 5;
                let currentPage = 1;

                async function renderPage(page) {
    const start = (page - 1) * pageSize;
    const pagedUsers = users.slice(start, start + pageSize);

    // Para cada usuário, buscar os dados de bounce
    const usersWithBounce = await Promise.all(pagedUsers.map(async (user) => {
        const bounceData = await fetchBounceData(user.username);
        return {
            ...user,
            bounce_percent: bounceData ? bounceData.bounce_percent : 'N/A',
            rejects: bounceData ? bounceData.rejects : 0,
            softbounces: bounceData ? bounceData.softbounces : 0,
            hardbounces: bounceData ? bounceData.hardbounces : 0,
            emails: bounceData ? bounceData.emails : 0,
        };
    }));

    const rows = usersWithBounce.map(user => `
        <tr>
            <td>${user.username}</td>
            <td>
                <span class="badge ${user.status === 'allowed' ? 'bg-success' : 'bg-secondary'}">
                    ${user.status.charAt(0).toUpperCase() + user.status.slice(1)}
                </span>
            </td>
            <td>
                ${user.rejects} rejeitados<br>
                ${user.softbounces} soft bounces<br>
                ${user.hardbounces} hard bounces<br>
                <strong>${user.bounce_percent}%</strong>
            </td>
        </tr>
    `).join('');

    // Calcular Bounce % Total baseado no total de e-mails enviados
    let totalSoftBounces = 0;
    let totalHardBounces = 0;
    let totalEmails = 0;

    usersWithBounce.forEach(user => {
        totalSoftBounces += Number(user.softbounces) || 0;
        totalHardBounces += Number(user.hardbounces) || 0;
        totalEmails += Number(user.emails) || 0;
    });

    const totalBounceRate = totalEmails > 0
        ? (((totalSoftBounces + totalHardBounces) / totalEmails) * 100).toFixed(2)
        : 'N/A';

    container.innerHTML = `
        <table class="table table-sm table-striped table-bordered">
            <thead class="table-light">
                <tr>
                    <th>E-mail</th>
                    <th>Status</th>
                    <th>Dados de Bounce</th>
                </tr>
            </thead>
            <tbody>
                ${rows}
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="2" class="text-end fw-bold">Bounce % Total:</td>
                    <td><strong>${totalBounceRate === 'N/A' ? 'N/A' : totalBounceRate + '%'}</strong></td>
                </tr>
            </tfoot>
        </table>
        <nav>
            <ul class="pagination pagination-sm justify-content-center mb-0">
                ${renderPagination(page)}
            </ul>
        </nav>
    `;

    container.querySelectorAll('.page-link').forEach(link => {
        link.addEventListener('click', e => {
            e.preventDefault();
            const selectedPage = parseInt(e.target.dataset.page);
            if (selectedPage && selectedPage !== currentPage) {
                currentPage = selectedPage;
                renderPage(currentPage);
            }
        });
    });
}



                function renderPagination(current) {
                    const totalPages = Math.ceil(users.length / pageSize);
                    let html = '';

                    html += `<li class="page-item ${current === 1 ? 'disabled' : ''}">
                <a href="#" class="page-link" data-page="${current - 1}" aria-label="Anterior">&laquo;</a>
            </li>`;

                    for (let i = 1; i <= totalPages; i++) {
                        html += `<li class="page-item ${i === current ? 'active' : ''}">
                    <a href="#" class="page-link" data-page="${i}">${i}</a>
                </li>`;
                    }

                    html += `<li class="page-item ${current === totalPages ? 'disabled' : ''}">
                <a href="#" class="page-link" data-page="${current + 1}" aria-label="Próximo">&raquo;</a>
            </li>`;

                    return html;
                }

                await renderPage(currentPage);

            } catch (err) {
                container.innerHTML = `<div class="text-danger">Erro: ${err.message}</div>`;
            }
        }


        function filterAccounts() {
            const query = searchInput.value.trim().toLowerCase();
            if (!query) {
                renderTable(accounts);
                return;
            }
            const filtered = accounts.filter(acc => acc.name.toLowerCase().includes(query));
            renderTable(filtered);
        }

        async function loadAccounts() {
            tableBody.innerHTML = '<tr><td colspan="5" class="text-center">Carregando...</td></tr>';
            try {
                const response = await fetch('?json=1');
                if (!response.ok) throw new Error('Falha ao buscar dados');
                const data = await response.json();
                if (data.error) throw new Error(data.error);

                accounts = data.subaccounts;
                renderTable(accounts);
            } catch (e) {
                tableBody.innerHTML = `<tr><td colspan="5" class="text-center text-danger">Erro ao carregar dados: ${e.message}</td></tr>`;
                console.error(e);
            }
        }

        searchInput.addEventListener('input', filterAccounts);

        loadAccounts();
    </script>

</body>

</html>