<?php
$apiKey = 'api-6FD2EBA86CC9401AB64F67723212FD98';

// Função para buscar subcontas
function getSubaccounts($apiKey) {
    $url = 'https://api.smtp2go.com/v3/subaccounts/search';
    $data = [
        'limit' => 50
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'X-Smtp2go-Api-Key: ' . $apiKey
    ]);

    $response = curl_exec($ch);
    curl_close($ch);

    return json_decode($response, true);
}

// Função para excluir subconta
function closeSubaccount($apiKey, $id) {
    $url = 'https://api.smtp2go.com/v3/subaccount/close';
    $data = [
        'id' => $id
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'X-Smtp2go-Api-Key: ' . $apiKey
    ]);

    $response = curl_exec($ch);
    curl_close($ch);

    return json_decode($response, true);
}

// Se houver solicitação para excluir
if (isset($_GET['excluir'])) {
    $id = $_GET['excluir'];
    $res = closeSubaccount($apiKey, $id);
    echo "<p>Subconta $id excluída com sucesso!</p>";
}

// Buscar lista de subcontas
$subaccounts = getSubaccounts($apiKey);
?>

<table border="1" cellpadding="5">
    <tr>
        <th>Nome</th>
        <th>Plano (Total)</th>
        <th>Usados</th>
        <th>Restantes</th>
        <th>Status</th>
        <th>Excluir</th>
        <th>Criar</th>
    </tr>
    <?php foreach ($subaccounts['data'] as $sub): ?>
        <tr>
            <td><?= htmlspecialchars($sub['name']) ?></td>
            <td><?= $sub['plan']['emails_per_month'] ?></td>
            <td><?= $sub['emails_used'] ?></td>
            <td><?= $sub['plan']['emails_per_month'] - $sub['emails_used'] ?></td>
            <td><?= $sub['status'] ?></td>
            <td>
                <?php if ($sub['status'] === 'Active'): ?>
                    <a href="?excluir=<?= urlencode($sub['id']) ?>" onclick="return confirm('Tem certeza que deseja excluir esta subconta?')">Excluir</a>
                <?php else: ?>
                    -
                <?php endif; ?>
            </td>
            <td><a href="criar.php">Criar</a></td>
        </tr>
    <?php endforeach; ?>
</table>
