<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();

// Se já estiver logado, redireciona para index.php
if (isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit;
}

$error = '';
$email = '';

// Inclui o arquivo de conexão e valida a conexão
require_once 'conexao.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = filter_var($_POST['email'] ?? '', FILTER_VALIDATE_EMAIL);
    $senha = $_POST['password'] ?? '';

    if (!$email || empty($senha)) {
        $error = "Preencha e-mail e senha corretamente.";
    } else {
        try {
            // Busca o usuário pelo email
            $stmt = $pdo->prepare("SELECT id, password_hash FROM users WHERE email = ?");
            $stmt->execute([$email]);
            $userData = $stmt->fetch();

            if ($userData && password_verify($senha, $userData['password_hash'])) {
                $_SESSION['user_id'] = $userData['id'];
                $_SESSION['user_email'] = $email;

                // Atualiza last_login
                $stmt = $pdo->prepare("UPDATE users SET last_login = NOW() WHERE id = ?");
                $stmt->execute([$userData['id']]);

                header("Location: index.php");
                exit;
            } else {
                $error = "E-mail ou senha inválidos.";
            }
        } catch (PDOException $e) {
            $error = "Erro no banco de dados: " . $e->getMessage();
        }
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Login - Monitor SMTP</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
  <style>
    body {
      background: linear-gradient(135deg, #1e3c72, #2a5298);
      height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
      color: #fff;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    .login-container {
      background: rgba(255, 255, 255, 0.1);
      padding: 2.5rem 3rem;
      border-radius: 12px;
      box-shadow: 0 8px 24px rgb(0 0 0 / 0.2);
      width: 100%;
      max-width: 400px;
      backdrop-filter: blur(8px);
    }
    .login-container h2 {
      margin-bottom: 1.8rem;
      font-weight: 700;
      text-align: center;
      letter-spacing: 1.5px;
    }
    .form-control {
      background: rgba(255, 255, 255, 0.15);
      border: none;
      color: #fff;
      font-size: 1rem;
    }
    .form-control:focus {
      background: rgba(255, 255, 255, 0.3);
      color: #000;
      box-shadow: none;
      border: none;
    }
    ::placeholder {
      color: #e0e0e0;
      opacity: 1;
    }
    .btn-login {
      background: #007bff;
      border: none;
      font-weight: 600;
      padding: 0.6rem 0;
      transition: background-color 0.3s ease;
    }
    .btn-login:hover {
      background: #0056b3;
    }
    .text-muted {
      color: #cbd5e1 !important;
    }
    .error-msg {
      background: #dc3545;
      padding: 0.8rem 1rem;
      border-radius: 6px;
      margin-bottom: 1rem;
      text-align: center;
      font-weight: 600;
      color: white;
    }
  </style>
</head>
<body>
  <main class="login-container">
    <h2>Monitor SMTP</h2>
    <?php if ($error): ?>
      <div class="error-msg"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>
    <form method="POST" action="">
      <div class="mb-3">
        <label for="inputEmail" class="form-label">E-mail</label>
        <input
          type="email"
          name="email"
          class="form-control"
          id="inputEmail"
          placeholder="seuemail@exemplo.com"
          required
          value="<?= htmlspecialchars($email) ?>"
        />
      </div>
      <div class="mb-4">
        <label for="inputPassword" class="form-label">Senha</label>
        <input
          type="password"
          name="password"
          class="form-control"
          id="inputPassword"
          placeholder="********"
          required
        />
      </div>
      <button type="submit" class="btn btn-login w-100">Entrar</button>
      <p class="mt-3 text-center text-muted" style="font-size: 0.9rem;">
        © 2025 Meile - Todos os direitos reservados
      </p>
    </form>
  </main>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
