<?php
require 'vendor/autoload.php';
use GuzzleHttp\Client;

$subaccountApiKey = "api-99C6C8C935F0429B9A1AE02B019632F5";

$client = new Client();

try {
    $response = $client->request('POST', 'https://api.smtp2go.com/v3/stats/email_summary', [
        'headers' => [
            'Content-Type' => 'application/json',
            'X-Smtp2go-Api-Key' => $subaccountApiKey,
            'accept' => 'application/json'
        ]
    ]);

    $data = json_decode($response->getBody(), true)['data'];

} catch (\GuzzleHttp\Exception\RequestException $e) {
    die("Erro na API: " . $e->getMessage());
}

?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Resumo de Emails - SMTP2GO</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-5">
    <h2 class="mb-4">Resumo de Emails da Subconta</h2>
    <div class="card">
        <div class="card-body">
            <table class="table table-striped table-bordered">
                <tbody>
                    <tr>
                        <th>Ciclo</th>
                        <td><?= $data['cycle_start'] ?> até <?= $data['cycle_end'] ?></td>
                    </tr>
                    <tr>
                        <th>Total de Emails Permitidos</th>
                        <td><?= number_format($data['cycle_max']) ?></td>
                    </tr>
                    <tr>
                        <th>Emails Usados</th>
                        <td><?= number_format($data['cycle_used']) ?></td>
                    </tr>
                    <tr>
                        <th>Emails Restantes</th>
                        <td><?= number_format($data['cycle_remaining']) ?></td>
                    </tr>
                    <tr>
                        <th>Total de Emails Enviados</th>
                        <td><?= number_format($data['email_count']) ?></td>
                    </tr>
                    <tr>
                        <th>Rejeitados (Bounces)</th>
                        <td><?= number_format($data['bounce_rejects']) ?></td>
                    </tr>
                    <tr>
                        <th>Soft Bounces</th>
                        <td><?= number_format($data['softbounces']) ?></td>
                    </tr>
                    <tr>
                        <th>Hard Bounces</th>
                        <td><?= number_format($data['hardbounces']) ?></td>
                    </tr>
                    <tr>
                        <th>% Rejeitados</th>
                        <td><?= $data['bounce_percent'] ?>%</td>
                    </tr>
                    <tr>
                        <th>Spam Rejeitado</th>
                        <td><?= number_format($data['spam_rejects']) ?></td>
                    </tr>
                    <tr>
                        <th>Spam Percentual</th>
                        <td><?= $data['spam_percent'] ?>%</td>
                    </tr>
                    <tr>
                        <th>Cancelamentos (Unsubscribes)</th>
                        <td><?= $data['unsubscribes'] ?> (<?= $data['unsubscribe_percent'] ?>%)</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
</body>
</html>
