<?php

class Sql extends PDO
{
    private $conn;
    private $user = "maverp";
    private $pass = "ddd001";

    public function __construct()
    {
        try {
            $this->conn = new \PDO(
                'pgsql:host=127.0.0.1;port=5433;dbname=maverp',
                $this->user,
                $this->pass
            );
            $this->conn->exec("set names utf8");
        } catch (\PDOException $e) {
            die("Erro de conexão com o PostgreSQL: " . $e->getMessage());
        }
    }

    private function setParams($statement, $parameters = array())
    {
        foreach ($parameters as $key => $value) {
            $this->setParam($statement, $key, $value);
        }
    }

    private function setParam($statement, $key, $value)
    {
        $statement->bindParam($key, $value);
    }

    public function query($rawQuery, $params = array())
    {
        $stmt = $this->conn->prepare($rawQuery);
        $this->setParams($stmt, $params);
        $stmt->execute();
        return $stmt;
    }

    public function rowquery($rawQuery, $params = array())
    {
        $stmt = $this->query($rawQuery, $params);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
