<?php
require_once 'src/user/checkLogin.php';
require_once("config.php");

$resultado = "";
$write_in_file_message_status = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['option'] == "Filter") {
    $search = new SqlDados($mysql);
    $domainDate = $search->filter($_POST['SearchValue']);
} elseif ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['option'] == "Open_Tickets") {
    //Debug:
    //echo "1-Importando lista de emails<br>";
    //Fim-Debug
    // Obtém os dados da caixa de texto
    $emails = $_POST['emails'];

    // Função para verificar se o e-mail é válido
    function isValidEmail($email)
    {
        // Verifica se o e-mail está no formato correto usando a função filter_var
        return filter_var($email, FILTER_VALIDATE_EMAIL) !== false;
    }

    // Divide os e-mails por linhas e remove espaços em branco desnecessários
    $emailArray = array_map('trim', explode("\n", $emails));

    // Remove linhas em branco e filtra e-mails inválidos
    $filteredEmails = array_filter($emailArray, function ($email) {
        return !empty($email) && isValidEmail($email);
    });

    // Abre o arquivo CSV para escrita
    $file = fopen('lista.csv', 'w');

    if ($file !== false) {
        // Escreve cada e-mail no arquivo CSV
        foreach ($filteredEmails as $email) {
            fputcsv($file, [$email]);
            //Debug
            //echo "2-Salvando: $email<br>";
            //Fim-Debug
        }
        fclose($file);
        $write_in_file_message_status = "True";

        $write_in_file_message = "2-E-mails salvos com sucesso em lista.csv.<br>";
        //Debug
        //echo $write_in_file_message;
        //Fim-Debug

    } else {
        $write_in_file_message_status = "False";
        $write_in_file_message =  "2-Erro ao abrir o arquivo lista.csv para escrita.<br>";
        echo $write_in_file_message;
    }
    //Debug
    //echo "3-Iniciando função para abrir achamados<br>";
    //Fim-Debug

    /*
    Abre chamados de contas capturadas e adiciona o primeiro contato que atende aos critérios como participante.
    */

    $file_handle = fopen("lista.csv", "r+");
    $data = array();
    $result = array();
    $final = array();
    $final1 = array();
    $arrayRevenda = array();
    $arrayClienteFinal = array();

    // Lê o arquivo CSV
    while (!feof($file_handle)) {
        //Debug
        //echo "4-Dentro do looping-Lê o arquivo CSV<br>";
        //Fim-Debug
        $line_of_text = fgetcsv($file_handle, 1024);
        if ($line_of_text && !empty($line_of_text[0])) {
            $data[] = $line_of_text;
            //Debug
            //echo "4-Conteudo do arquivo: ", $line_of_text[0], "<br>";
            //Fim-Debug
        }
    }

    // Pega cliente Id da revenda
    foreach ($data as $i => $entry) {
        //Debug
        //echo "5-Foreach: Pega ID da Revenda<br>";
        $dados = explode('@', $entry[0]);
        $email = $entry[0];
        $dominio = $dados[1] ?? '';  // Verificação se existe domínio
        if ($dominio) {
            //Debug
            //echo "5-Dominio: $dominio<br>";
            //Fim-Debug
            $result[$i] = Consultas::select("SELECT c.id FROM mhpdominios mhp INNER JOIN clientes c ON mhp.cliente_id = c.id WHERE mhp.dominio = '$dominio' AND status != 'erased'");
            //Debug
            //echo "5-Resultado Obtido: ", var_dump($result[$i]), "<br>";
            //Fim-debug
            if (!empty($result[$i])) {
                $final[$i] = [
                    'id' => (int)$result[$i][0]['id'],  // Assegura que é um número inteiro
                    'email' => $email
                ];
            }
            //Debug
            else {
                //echo "5-Resultado não obtido para: ", $dominio, "<br>";
            }
            //Fim-debug
        }
    }



    // Organiza os dados de revenda
    foreach ($final as $item) {
        if (isset($item["id"])) {
            $arrayRevenda[] = $item;
        }
    }

    // Pega cliente id de cliente final
    foreach ($data as $i => $entry) {
        //Debug
        //echo "6-Foreach: Pega ID do Cliente Final<br>";
        //Fim-debug
        $dados = explode('@', $entry[0]);
        $email = $entry[0];
        
        $dominio = $dados[1] ?? '';  // Verificação se existe domínio
        //Debug
        //echo "6-Dominio: $dominio<br>";
        //Fim-debug
        if ($dominio) {
            $result[$i] = Consultas::select("SELECT c.id FROM dominios dom INNER JOIN clientes c ON dom.cliente_id = c.id WHERE dom.dominio = '$dominio'");
            
            //Debug
            //echo "6-Resultado Obtido: ", var_dump($result[$i]), "<br>";
            //Fim-debug

            if (!empty($result[$i])) {
                $final1[$i] = [
                    'id' => (int)$result[$i][0]['id'],  // Assegura que é um número inteiro
                    'email' => $email
                ];
            }
            //Debug
            else {
                //echo "6-Resultado não obtido para: ", $dominio, "<br>";
            }
            //Fim-debug
        }
    }

    // Organiza os dados de cliente final
    foreach ($final1 as $item) {
        if (isset($item["id"])) {
            $arrayClienteFinal[] = $item;
        }
    }

    // Mescla arrays de resultados
    $resultado = array_merge($arrayClienteFinal, $arrayRevenda);
    //Debug
    //echo "7-Mescla arrays de resultados de Revenda e Cliente Final: ", var_dump($resultado), "<br>";
    //Fim-debug


    // Limpa o arquivo CSV
    ftruncate($file_handle, 0);
    fclose($file_handle);


        /**
     * Função genérica para fazer requisições cURL
     */
    function curlRequest($url, $data)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ),
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false,
        ));

        $response = curl_exec($curl);

        if (curl_errno($curl)) {
            echo 'Erro na requisição: ' . curl_error($curl);
        }

        curl_close($curl);

        //Echo adicionado para ver resultado
        //echo $response;

        return $response;
    }
    /**
     * Função para abrir um chamado
     */
    function abrirChamado($cliente_id, $email, $titulo_chamado, $descricao_chamado)
    {
        $usuario = getenv('MAV_API_USER');
        $senha = getenv('MAV_API_PASSWORD');

        $data = array(
            'usuario' => $usuario,
            'senha' => $senha,
            'chamada' => 'abrirChamadoSuporte',
            'parametros' => array(
                $usuario,
                'cliente_id' => (int)$cliente_id,  // Assegura que é um número inteiro
                'aberto_por' => 'MAV Tecnologia',
                'titulo_chamado' => "Ação Interna Requerida: " . ($titulo_chamado ?: 'Sem assunto'),
                'descricao_chamado' => $descricao_chamado ?: 'Sem descrição fornecida.',                
                'fila_id' => 10
            )
        );

        return curlRequest('https://homologation-api-erp.mav.com.br:9090/chamados', $data);
    }

    /**
     * Função para buscar contato
     */
    function buscarContato($cliente_id)
    {
        $usuario = getenv('MAV_API_USER');
        $senha = getenv('MAV_API_PASSWORD');

        $data = array(
            'usuario' => $usuario,
            'senha' => $senha,
            'chamada' => 'listaContatos',
            'parametros' => array(
                'cliente_id' => (int)$cliente_id  // Assegura que é um número inteiro
            )
        );

        $response = curlRequest('https://homologation-api-erp.mav.com.br:9090/contatos', $data);
        $data = json_decode($response, true);
	
	if (isset($data['resultado']) && is_array($data['resultado'])) {
        // Primeiro, verifica as três condições incluindo tipo_id 0 ou 1
        foreach ($data['resultado'] as $contato) {
            if (
                 $contato['ativo'] == 't' && 
                $contato['acesso_portal'] == 't' && 
                $contato['gestor_ti'] == 't' && 
                ($contato['tipo_id'] == 0 || $contato['tipo_id'] == 1)
            ) {
                return $contato;
            }
        }
        
        // Se nenhum contato atendeu à primeira condição, verifica apenas se está ativo e tem tipo_id 0 ou 1
        foreach ($data['resultado'] as $contato) {
            if (
                $contato['ativo'] == 't' && 
                ($contato['tipo_id'] == 0 || $contato['tipo_id'] == 1)
            ) {
                return $contato;
            }
        }
    }

      return null;
    }

    /**
     * Função para adicionar participante ao chamado
     */
    function adicionarParticipante($chamado_id, $contato_id, $contato_nome)
    {
        $usuario = getenv('MAV_API_USER');
        $senha = getenv('MAV_API_PASSWORD');

        $data = array(
            'usuario' => $usuario,
            'senha' => $senha,
            'chamada' => 'adicionarParticipanteChamado',
            'parametros' => array(
                'chamado_id' => (int)$chamado_id,  // Assegura que é um número inteiro
                'contato_id' => (int)$contato_id,  // Assegura que é um número inteiro
                'contato_nome' => $contato_nome
            )
        );

        return curlRequest('https://homologation-api-erp.mav.com.br:9090/chamados', $data);
    }

    // Abre chamados e adiciona participante
    foreach ($resultado as $result) {
        //Debug
        //echo "8-Looping - Abre chamados e adiciona participante <br>";
        //Fim-debug

        $cliente_id = $result['id'];
        $email = $result['email'];

        //Debug
        //echo "8-Cliente ID: $cliente_id | Cliente e-mail: $email<br>";
        //Fim-debug

        //Debug
        //echo "9-Função abrirChamado...<br>";
        //Fim-debug

        // Abre o chamado
        $titulo_chamado_usuario = $_POST['titulo_chamado'] ?? '';
        $descricao_chamado_usuario = $_POST['descricao_chamado'] ?? '';

        $response = abrirChamado($cliente_id, $email, $titulo_chamado_usuario, $descricao_chamado_usuario);
        $responseData = json_decode($response, true);

        //Debug
        //echo "9-Função abrirChamado executada: $responseData<br>";
        //Fim-debug

        // Verifica se o chamado foi aberto com sucesso
        if (isset($responseData['resultado']['chamado_id'])) {
            $chamado_id = (int)$responseData['resultado']['chamado_id'];

            // Busca contato que atenda aos critérios
            $contato = buscarContato($cliente_id);

            if ($contato) {
                // Adiciona participante ao chamado
                $addResponse = adicionarParticipante($chamado_id, (int)$contato['id'], $contato['nome']);
                //echo "Participante adicionado: ";
                //print_r($addResponse);
            } else {
                echo "Nenhum contato encontrado que atenda aos critérios para o cliente $cliente_id.\n";
            }
        } else {
            echo "Erro ao abrir o chamado para o cliente $cliente_id: " . $response . "\n";
        }
    }
} else {
}





//Exibe os botões inferiores das SmallBoxes apenas neste HTML
$show_edit_button = true;
$show = false;
?>
<!DOCTYPE html>
<html lang="br">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Abrir Tickets</title>
    <?php require_once 'html/header/links.php'; ?>
</head>

<body class="hold-transition layout-top-nav">
    <div class="wrapper">
        <!-- Navbar -->

        <?php require_once 'html/navbar/navbar.php'; ?>
        <!-- /Navbar -->

        <!-- Content Wrapper. Contains page content -->
        <?php require_once 'pages/index/index_page_content.php'; ?>
        <!-- /.content-wrapper -->

        <!-- Footer -->
        <?php require_once 'html/footer/footer.php'; ?>
        <!-- /Footer -->

        <!-- Control Sidebar -->
        <aside class="control-sidebar control-sidebar-dark">
            <!-- Control sidebar content goes here -->
        </aside>
        <!-- /.control-sidebar -->

    </div>
    <!-- ./wrapper -->

    <!-- body scripts -->
    <?php require_once 'html/scripts/scripts.php'; ?>
</body>

</html>
