<?php
// Inicia sessão apenas se ainda não foi iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once 'src/user/checkLogin.php';
require_once("config.php");
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Inicializa $user_info para evitar warnings
$user_info = [
    'nome' => '',
    'email' => '',
    'userLevel' => 0
];

// Se a sessão do usuário estiver ativa, preenche $user_info
if (isset($_SESSION['UserSession'])) {
    $user_info['email'] = $_SESSION['UserSession'];
    $user_info['nome'] = $_SESSION['UserName'] ?? '';
    $user_info['userLevel'] = $_SESSION['UserLevel'] ?? 0;
}

$resultado = "";
$write_in_file_message_status = "";

// Função genérica cURL
function curlRequest($url, $data)
{
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false,
    ]);
    $response = curl_exec($curl);
    if (curl_errno($curl)) echo 'Erro na requisição: ' . curl_error($curl);
    curl_close($curl);
    return $response;
}

// Funções abrirChamado, buscarContato, adicionarParticipante
function abrirChamado($cliente_id, $email)
{
    $usuario = getenv('MAV_API_USER');
    $senha = getenv('MAV_API_PASSWORD');
    $data = [
        'usuario' => $usuario,
        'senha' => $senha,
        'chamada' => 'abrirChamadoSuporte',
        'parametros' => [
            $usuario,
            'cliente_id' => (int)$cliente_id,
            'aberto_por' => 'MAV Tecnologia',
            'titulo_chamado' => "Conta Capturada: " . $email,
            'descricao_chamado' => "Conta: " . $email . "\n\nObs: Deve-se seguir o procedimento.",
            'fila_id' => 10
        ]
    ];
    return curlRequest('https://homologation-api-erp.mav.com.br:9090/chamados', $data);
}

function buscarContato($cliente_id)
{
    $usuario = getenv('MAV_API_USER');
    $senha = getenv('MAV_API_PASSWORD');
    $data = [
        'usuario' => $usuario,
        'senha' => $senha,
        'chamada' => 'listaContatos',
        'parametros' => ['cliente_id' => (int)$cliente_id]
    ];
    $response = curlRequest('https://homologation-api-erp.mav.com.br:9090/contatos', $data);
    $data = json_decode($response, true);
    if (isset($data['resultado']) && is_array($data['resultado'])) {
        foreach ($data['resultado'] as $contato) {
            if (
                $contato['ativo'] == 't' &&
                $contato['acesso_portal'] == 't' &&
                $contato['gestor_ti'] == 't' &&
                ($contato['tipo_id'] == 0 || $contato['tipo_id'] == 1)
            ) return $contato;
        }
        foreach ($data['resultado'] as $contato) {
            if (
                $contato['ativo'] == 't' &&
                ($contato['tipo_id'] == 0 || $contato['tipo_id'] == 1)
            ) return $contato;
        }
    }
    return null;
}

function adicionarParticipante($chamado_id, $contato_id, $contato_nome)
{
    $usuario = getenv('MAV_API_USER');
    $senha = getenv('MAV_API_PASSWORD');
    $data = [
        'usuario' => $usuario,
        'senha' => $senha,
        'chamada' => 'adicionarParticipanteChamado',
        'parametros' => [
            'chamado_id' => (int)$chamado_id,
            'contato_id' => (int)$contato_id,
            'contato_nome' => $contato_nome
        ]
    ];
    return curlRequest('https://homologation-api-erp.mav.com.br:9090/chamados', $data);
}

// Função para validar e-mails
function isValidEmail($email)
{
    return filter_var($email, FILTER_VALIDATE_EMAIL) !== false;
}

// Inicializa arrays para mensagens de sucesso e erro
$successMessages = [];
$errorMessages = [];

// Processamento do formulário
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    if ($_POST['option'] == "Filter") {
        $search = new SqlDados($mysql);
        $domainDate = $search->filter($_POST['SearchValue']);
    } elseif ($_POST['option'] == "Open_Tickets") {

        $emails = $_POST['emails'];

        // Divide e-mails e remove inválidos
        $emailArray = array_map('trim', explode("\n", $emails));
        $filteredEmails = array_filter($emailArray, function ($email) {
            return !empty($email) && isValidEmail($email);
        });

        foreach ($filteredEmails as $email) {
            $dados = explode('@', $email);
            $dominio = $dados[1] ?? '';

            if ($dominio) {
                $result = Consultas::select(
                    "SELECT c.id FROM mhpdominios mhp 
                     INNER JOIN clientes c ON mhp.cliente_id = c.id 
                     WHERE mhp.dominio = '$dominio' AND status != 'erased'
                     UNION
                     SELECT c.id FROM dominios dom 
                     INNER JOIN clientes c ON dom.cliente_id = c.id 
                     WHERE dom.dominio = '$dominio'"
                );

                if (!empty($result)) {
                    $cliente_id = (int)$result[0]['id'];

                    $response = abrirChamado($cliente_id, $email);
                    $responseData = json_decode($response, true);

                    if (isset($responseData['resultado']['chamado_id'])) {
                        $chamado_id = (int)$responseData['resultado']['chamado_id'];

                        $contato = buscarContato($cliente_id);
                        if ($contato) {
                            adicionarParticipante($chamado_id, (int)$contato['id'], $contato['nome']);
                        }

                        $successMessages[] = [
                            'email' => $email,
                            'chamado_id' => $chamado_id,
                            'contato' => $contato['nome'] ?? 'Nenhum contato'
                        ];
                    } else {
                        $errorMessages[] = "Erro ao abrir o chamado para o cliente $cliente_id: " . $response;
                    }
                } else {
                    $errorMessages[] = "Nenhum cliente encontrado para o domínio $dominio.";
                }
            }
        }
    }
}

// Exibe botões inferiores das SmallBoxes apenas neste HTML
$show_edit_button = true;
$show = false;
?>
<!DOCTYPE html>
<html lang="br">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Abrir Tickets</title>
    <!-- Bootstrap CSS (ou já incluir no links.php) -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <?php require_once 'html/header/links.php'; ?>
</head>

<body class="hold-transition layout-top-nav">
    <div class="wrapper">
        <?php require_once 'html/navbar/navbar.php'; ?>

        <div class="container mt-4">

            <!-- Mensagens de Sucesso -->
            <?php if (!empty($successMessages)): ?>
                <div class="alert" style="background-color: #F3F3F3; color: #000;">
                    <h5>Chamados abertos com sucesso:</h5>
                    <table class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>E-mail</th>
                                <th>Chamado ID</th>
                                <th>Contato</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($successMessages as $msg): ?>
                                <tr>
                                    <td><?= htmlspecialchars($msg['email']) ?></td>
                                    <td>
                                        <a href="https://erp.mav.com.br/chamados/chamado/<?= htmlspecialchars($msg['chamado_id']) ?>"
                                            target="_blank"
                                            style="color: #000; text-decoration: underline;">
                                            <?= htmlspecialchars($msg['chamado_id']) ?>
                                        </a>
                                    </td>

                                    <td><?= htmlspecialchars($msg['contato']) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>

            <!-- Mensagens de Erro -->
            <?php if (!empty($errorMessages)): ?>
                <div class="alert alert-danger">
                    <h5>Erros encontrados:</h5>
                    <ul>
                        <?php foreach ($errorMessages as $error): ?>
                            <li><?= htmlspecialchars($error) ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endif; ?>

            <?php require_once 'pages/index/index_page_content.php'; ?>
        </div>

        <?php require_once 'html/footer/footer.php'; ?>
        <aside class="control-sidebar control-sidebar-dark"></aside>
    </div>
    <?php require_once 'html/scripts/scripts.php'; ?>
</body>

</html>