<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0"><small>Personalizados</small></h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="index_Personalizado.php">Home</a></li>
                        <li class="breadcrumb-item active">Personalizados</li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
    <!-- Main content -->
    <div class="content">
        <!-- container-fluid -->
        <div class="container">
            <!-- Content Wrapper. Contains page content -->
            <div class="content-wrapper">
                <section class="content">
                    <div class="container-fluid">
                        <div class="row">
                            <?php if ($write_in_file_message_status === "True"): ?>
                                <div class="col-12">
                                    <div class="card">
                                        <div class="card-body">
                                            <?php
                                            // Array para armazenar os dados
                                            $dados = [];

                                            // Supondo que $resultado seja um array de resultados
                                            foreach ($resultado as $result) {
                                                $cliente_id = $result['id'];
                                                $email = $result['email'];

                                                // Chama a função e obtém a resposta
                                                $response = abrirChamado($cliente_id, $email);

                                                // Decodifica a resposta JSON
                                                $responseData = json_decode($response, true);

                                                // Verifica se a resposta tem o status de sucesso e se contém chamado_id
                                                if ($responseData['status'] === 'sucesso' && isset($responseData['resultado']['chamado_id'])) {
                                                    $chamado_id = $responseData['resultado']['chamado_id'];

                                                    // Adiciona os dados ao array
                                                    $dados[] = [
                                                        'email' => $email,
                                                        'chamado_id' => $chamado_id
                                                    ];
                                                }
                                            }

                                            // Imprime os dados
                                            #foreach ($dados as $dado) {
                                            #    echo "Seu email é {$dado['email']} e seu id é {$dado['chamado_id']}.\n";
                                            #}
                                            ?>
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>Email</th>
                                                        <th>Chamado ID</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php
                                                    // Exibir os resultados em uma tabela
                                                    foreach ($dados as $dado) {
                                                        echo '<tr>';
                                                        echo "<td>" . $dado['email'] . "</td>";
                                                        echo '<td><a href="https://erp.mav.com.br/chamados/chamado/' . htmlspecialchars($dado['chamado_id']) . '" target="_blank">' . htmlspecialchars($dado['chamado_id']) . '</a></td>';
                                                        echo '</tr>';
                                                    }
                                                    ?>
                                                </tbody>
                                            </table>

                                        </div>
                                        <!-- /.card-body -->
                                    </div>
                                    <!-- /.card -->
                                </div>
                            <?php endif; ?>
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="card-header text-center mt-4 mb-4">
                                            <h3>Abrir Tickets</h3>
                                        </div>
                                        <form action="index_Personalizado.php" method="post">

                                            <!-- Campo para o nome do responsável -->
                                            <div class="mb-3">
                                                <label for="aberto_por" class="form-label">Aberto Por:</label>
                                                <!-- <input type="text" id="aberto_por" name="aberto_por" class="form-control" value="<?php echo $UserData['userName']?>"> -->
                                                <input type="text" id="aberto_por" name="aberto_por" class="form-control" value="MAV Tecnologia" readonly disable>

                                            </div>

                                            <!-- Campo para o título do chamado -->
                                            <div class="mb-3">
                                                <label for="titulo_chamado" class="form-label">Título do Chamado:</label>
                                                <input type="text" id="titulo_chamado" name="titulo_chamado" class="form-control">
                                            </div>

                                            <!-- Campo para a descrição do chamado -->
                                            <div class="mb-3">
                                                <label for="descricao_chamado" class="form-label">Descrição do Chamado:</label>
                                                <textarea id="descricao_chamado" name="descricao_chamado" class="form-control" rows="5">
Obs: Deve-se seguir o procedimento.</textarea>
                                            </div>
                                            <div class="mb-3">
                                                <label for="emails" class="form-label">Contas de Emails ou Domínios:</label>
                                                <textarea id="emails" name="emails" class="form-control" rows="10" placeholder="Insira um domínio por linha"></textarea>
                                            </div>
                                            <input type="hidden" name="option" value="Open_Tickets">
                                            <button type="submit" class="btn btn-primary">Enviar</button>
                                        </form>
                                    </div>
                                    <!-- /.card-body -->
                                </div>
                                <!-- /.card -->
                            </div>
                        </div>
                        <!-- /.row -->
                    </div><!-- /.container-fluid -->
                </section>
                <!-- /.content -->
            </div>
            <!-- /.container-fluid -->
        </div>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->