<?php
require_once 'src/user/checkLogin.php';
require_once("config.php");

$resultado = "";
$write_in_file_message_status = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['option'] == "Filter") {
    $search = new SqlDados($mysql);
    $domainDate = $search->filter($_POST['SearchValue']);
} elseif ($_SERVER['REQUEST_METHOD'] === 'POST' && $_POST['option'] == "Open_Tickets") {
    // Obtém os dados da caixa de texto
    $emails = $_POST['emails'];

    // Função para verificar se o e-mail é válido
    function isValidEmail($email)
    {
        // Verifica se o e-mail está no formato correto usando a função filter_var
        return filter_var($email, FILTER_VALIDATE_EMAIL) !== false;
    }

    // Divide os e-mails por linhas e remove espaços em branco desnecessários
    $emailArray = array_map('trim', explode("\n", $emails));

    // Remove linhas em branco e filtra e-mails inválidos
    $filteredEmails = array_filter($emailArray, function ($email) {
        return !empty($email) && isValidEmail($email);
    });

    // Abre o arquivo CSV para escrita
    $file = fopen('lista.csv', 'w');

    if ($file !== false) {
        // Escreve cada e-mail no arquivo CSV
        foreach ($filteredEmails as $email) {
            fputcsv($file, [$email]);
        }
        fclose($file);
        $write_in_file_message_status = "True";
        $write_in_file_message = "E-mails salvos com sucesso em lista.csv.";
    } else {
        $write_in_file_message_status = "False";
        $write_in_file_message =  "Erro ao abrir o arquivo lista.csv para escrita.";
    }

    /*
    Abre chamados de contas capturadas.

    Edicione no arquivo listaDeContas.csv as contas uma em baixo da outra.

    */
    function abrirChamado($cliente_id, $email)
    {

        $usuario = getenv('MAV_API_USER');
        $senha = getenv('MAV_API_PASSWORD');

        $chamada = 'abrirChamadoSuporte';

        $aberto_por = $_POST['aberto_por'];
        $titulo_chamado = $_POST['titulo_chamado'];
        $descricao_chamado = "Conta: " . $email . "
        " . $_POST['descricao_chamado'];

        $fila_id = 10;

        $data = array(
            'usuario' => $usuario,
            'senha' => $senha,
            'chamada' => $chamada,
            'parametros' => array(
                $usuario,
                'cliente_id' => $cliente_id,
                'aberto_por' => $aberto_por,
                'titulo_chamado' => "$titulo_chamado $email",
                'descricao_chamado' => $descricao_chamado,
                'fila_id' => $fila_id
            )
        );

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://homologation-api-erp.mav.com.br:9090/chamados',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);
        $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);

        curl_close($curl);

        return $response;
    }

    $file_handle = fopen("lista.csv", "r+");
    $data = array();
    $result = array();
    $final = array();
    $final1 = array();
    $arrayMerge = array();
    $arrayRevenda = array();
    $arrayClienteFinal = array();


    while (!feof($file_handle)) {

        $line_of_text = fgetcsv($file_handle, 1024);
        $data[] = $line_of_text;
    }

    //Pega cliente Id da revenda
    for ($i = 0; $i < count($data); $i++) {

        $dados = explode('@', $data[$i][0]);
        $email = $data[$i][0];
        $dominio = $dados[1];

        $result[$i] = Consultas::select("SELECT c.id FROM mhpdominios mhp INNER JOIN clientes c ON mhp.cliente_id = c.id WHERE mhp.dominio='$dominio' and status!='erased'");

        array_push($final, $result[$i][0]);

        $final[$i]['email'] = $email;
    }


    for ($i = 0; $i < count($final); $i++) {
        if (isset($final[$i]["id"])) {
            // faça alguma coisa com o valor do índice 3
            $arrayRevenda[$i]["id"] = $final[$i]["id"];
            $arrayRevenda[$i]["email"] = $final[$i]["email"];
        }
    }

    // ############################  Pega cliente id de cliente final:

    for ($i = 0; $i < count($data); $i++) {

        $dados = explode('@', $data[$i][0]);
        $email = $data[$i][0];
        $dominio = $dados[1];

        $result[$i] = Consultas::select("SELECT c.id FROM dominios dom INNER JOIN clientes c ON dom.cliente_id = c.id WHERE dom.dominio='$dominio'");

        array_push($final1, $result[$i][0]);

        $final1[$i][0]['email'] = $email;
    }
    #var_dump($final1);exit;

    for ($i = 0; $i < count($final1); $i++) {
        if (isset($final1[$i]["id"])) {

            $arrayClienteFinal[$i]["id"] = $final1[$i]["id"];
            $arrayClienteFinal[$i]["email"] = $final1[$i][0]["email"];
        }
    }

    $resultado = array_merge($arrayClienteFinal, $arrayRevenda);


    /* Limpa o arquivo das contas */
    ftruncate($file_handle, 0);



    fclose($file_handle);

    #var_dump($tamanho); exit;
    echo "\n";
} else {
}





//Exibe os botões inferiores das SmallBoxes apenas neste HTML
$show_edit_button = true;
$show = false;
?>
<!DOCTYPE html>
<html lang="br">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Abrir Tickets Personalizados</title>
    <?php require_once 'html/header/links.php'; ?>
</head>

<body class="hold-transition layout-top-nav">
    <div class="wrapper">
        <!-- Navbar -->
        <?php require_once 'html/navbar/navbar.php'; ?>
        <!-- /Navbar -->

        <!-- Content Wrapper. Contains page content -->
        <?php require_once 'pages/personalized/personalized_page_content.php'; ?>
        <!-- /.content-wrapper -->

        <!-- Footer -->
        <?php require_once 'html/footer/footer.php'; ?>
        <!-- /Footer -->

        <!-- Control Sidebar -->
        <aside class="control-sidebar control-sidebar-dark">
            <!-- Control sidebar content goes here -->
        </aside>
        <!-- /.control-sidebar -->

    </div>
    <!-- ./wrapper -->

    <!-- body scripts -->
    <?php require_once 'html/scripts/scripts.php'; ?>
</body>

</html>
