<?php
class SqlDados
{
    private $mysql;

    public function __construct(mysqli $mysql)
    {
        $this->mysql = $mysql;
    }
    // --------------------------------- User Comands ---------------------------------------
    public function userDataByID(string $UserEmail): array
    {
        $prepare = $this->mysql->prepare("SELECT * FROM user_data_table WHERE userEmail = ?");
        $prepare->bind_param('s', $UserEmail);
        $prepare->execute();
        $results = $prepare->get_result()->fetch_assoc();

        if (!$results) {
            // Retorna um array vazio ou um array com valores padrão.
            return [];
        }

        return $results;
    }
    public function getUsersTable(): array
    {
        $query = $this->mysql->query('SELECT *, MD5(userPassword) as userPassword FROM user_data_table;');
        $results = $query->fetch_all(MYSQLI_ASSOC);
        return $results;
    }
    public function registerUser(string $name, string $email, string $level, string $password): void
    {
        $md5Result = md5($password);
        $prepare = $this->mysql->prepare('INSERT INTO user_data_table (userName, userEmail, userLevel, userPassword) VALUES(?,?,?,?);');
        $prepare->bind_param('ssss', $name, $email, $level, $md5Result);
        $prepare->execute();
    }
    public function updateUser(string $name, string $email, string $password, string $userEmail): void
    {
        $md5_password=md5($password);
        $prepare = $this->mysql->prepare('UPDATE user_data_table SET userName = ?, userEmail = ?, userPassword = ? WHERE userEmail = ?');
        $prepare->bind_param('ssss', $name, $email, $md5_password, $userEmail);
        $prepare->execute();
    }
    public function editUser(string $name, string $email, string $password, string $level, string $userEmail): void
    {
        $md5_password=md5($password);
        $prepare = $this->mysql->prepare('UPDATE user_data_table SET userName = ?, userEmail = ?, userPassword = ?, userLevel = ? WHERE userEmail = ?');
        $prepare->bind_param('sssss', $name, $email, $md5_password, $level, $userEmail);
        $prepare->execute();
    }
    public function deleteUser(string $email): void
    {
        $prepare = $this->mysql->prepare('DELETE FROM `user_data_table` WHERE `user_data_table`.`userEmail` = ?');
        $prepare->bind_param('s', $email);
        $prepare->execute();
    }
    public function simpleEditUser(string $name, string $email, string $level, string $userEmail): void
    {
        $prepare = $this->mysql->prepare('UPDATE user_data_table SET userName = ?, userEmail = ?, userLevel = ? WHERE userEmail = ?');
        $prepare->bind_param('ssss', $name, $email, $level, $userEmail);
        $prepare->execute();
    }
    public function filterUsers(string $word): array
    {
        $parameter="%".$word."%";
        $prepare = $this->mysql->prepare('SELECT *  FROM user_data_table WHERE (userName LIKE ? ) OR (userEmail LIKE ? ) OR (userLevel LIKE ? ) ORDER BY userName DESC');
        $prepare->bind_param('sss', $parameter, $parameter, $parameter);
        $prepare->execute();
        $results = $prepare->get_result()->fetch_all(MYSQLI_ASSOC);

        return $results;
    }
    // --------------------------------- Domains Comands ---------------------------------------
    public function getDomainData(): array
    {
        $query = $this->mysql->query('SELECT * FROM domains ORDER BY domainDate DESC');
        $results = $query->fetch_all(MYSQLI_ASSOC);
        return $results;
    }
    public function getdomainDate(int $domainID): array
    {
        $prepare = $this->mysql->prepare("SELECT * FROM domains WHERE domainID = ?");
        $prepare->bind_param('s', $domainID);
        $prepare->execute();
        $results = $prepare->get_result()->fetch_assoc();
        return $results;
    }
    public function addNewDomain(string $domainName, string $domainStatus, string $domainDescription, string $domainPlesk, string $domainPleskD, string $domainCreator, string $domainClient): void
    {
        $prepare = $this->mysql->prepare('INSERT INTO domains (domainName, domainStatus, domainDate, domainDescription, domainPlesk, domainPleskD, domainCreator, domainClient) SELECT ?, ?, DATE_FORMAT(CURRENT_TIMESTAMP(), "%d/%m/%Y %H:%i:%s"), ?, ?, ?, ?, ? FROM dual WHERE NOT EXISTS (SELECT domainName FROM domains WHERE domainName = ?)');
        $prepare->bind_param('ssssssss',$domainName, $domainStatus, $domainDescription, $domainPlesk, $domainPleskD, $domainCreator, $domainClient, $domainName);
        $prepare->execute();
        
    }
    public function removeDomain(string $domainID): void
    {
        $prepare = $this->mysql->prepare('DELETE FROM domains WHERE domainID = ?');
        $prepare->bind_param('s', $domainID);
        $prepare->execute();
    }
    public function editDomain(string $domainName, string $domainStatus, string $domainDescription, string $domainPlesk, string $domainPleskD, string $domainEditor, string $domainClient, string $domainID): void
    {
        $prepare = $this->mysql->prepare('UPDATE domains SET domainName = ?, domainStatus = ?, domainDate = DATE_FORMAT(CURRENT_TIMESTAMP(), "%d/%m/%Y %H:%i:%s"), domainDescription = ?, domainPlesk = ?, domainPleskD = ?, domainEditor = ?, domainClient = ? WHERE domainID = ?');
        $prepare->bind_param('ssssssss', $domainName, $domainStatus, $domainDescription, $domainPlesk, $domainPleskD, $domainEditor, $domainClient, $domainID);
        $prepare->execute();
    }
public function editDomains(array $dominiosArray, string $domainStatus): void
{
    foreach ($dominiosArray as $domainName) {
        if ($domainStatus === 'Erro_01') {
            $prepare = $this->mysql->prepare('UPDATE domains SET domainStatus = ?, domainDescription = "DNS externo, mas apontando para Lin1" WHERE domainName = ?');}
		elseif ($domainStatus === 'Erro_02') {
            $prepare = $this->mysql->prepare('UPDATE domains SET domainStatus = ?, domainDescription = "DNS e site externos" WHERE domainName = ?');}
		elseif ($domainStatus === 'Erro_03') {
            $prepare = $this->mysql->prepare('UPDATE domains SET domainStatus = ?, domainDescription = "DNS na Mav, mas site externo" WHERE domainName = ?');}
		elseif ($domainStatus === 'Erro_04') {
            $prepare = $this->mysql->prepare('UPDATE domains SET domainStatus = ?, domainDescription = "hospedado no Lin1, pois não abre no Legacy." WHERE domainName = ?');}
		elseif ($domainStatus === 'Erro_05') {
            $prepare = $this->mysql->prepare('UPDATE domains SET domainStatus = ?, domainDescription = "DNS externo, mas subdomínio aponta para o Lin1." WHERE domainName = ?');}
		elseif ($domainStatus === 'Erro_06') {
            $prepare = $this->mysql->prepare('UPDATE domains SET domainStatus = ?, domainDescription = "Erro: NXDOMAIN" WHERE domainName = ?');}
		elseif ($domainStatus === 'Erro_07') {
            $prepare = $this->mysql->prepare('UPDATE domains SET domainStatus = ?, domainDescription = "DNS externo, mas site aponta para o Lecacy" WHERE domainName = ?');
        } else {
            $prepare = $this->mysql->prepare('UPDATE domains SET domainStatus = ? WHERE domainName = ?');
        }

        $prepare->bind_param('ss', $domainStatus, $domainName);
        $prepare->execute();
    }
}
    public function search(string $word): array
    {
        $parameter="%".$word."%";
        $prepare = $this->mysql->prepare('SELECT *  FROM domains WHERE (domainName LIKE ? ) OR (domainClient LIKE ? ) ORDER BY domainID DESC');
        $prepare->bind_param('ss', $parameter, $parameter);
        $prepare->execute();
        $results = $prepare->get_result()->fetch_all(MYSQLI_ASSOC);

        return $results;
    }
    public function filter(string $word): array
    {
        $parameter="%".$word."%";
        $prepare = $this->mysql->prepare('SELECT *  FROM domains WHERE (domainName LIKE ? ) OR (domainDescription LIKE ? ) OR (domainDate LIKE ? ) OR (domainClient LIKE ? ) OR (domainStatus LIKE ? ) OR (domainPlesk LIKE ? ) ORDER BY domainID DESC');
        $prepare->bind_param('ssssss', $parameter, $parameter, $parameter, $parameter, $parameter, $parameter);
        $prepare->execute();
        $results = $prepare->get_result()->fetch_all(MYSQLI_ASSOC);

        return $results;
    }
}