<?php

class Csv{

	public function clientes_finais($lista, $arquivo){
        $header = ['Razão Social','Domínio','Pacote','Valor Rec','Usuários'];
        $linhaVazia = ['','','','','',''];

        $nome_arquivo = $arquivo . '_' . date("Y-m-d H:i:s") . '.csv';

        CSV::gerarCSV($lista, $header, $linhaVazia, $nome_arquivo);
           
        return $nome_arquivo;
    }


    public function clientes_mhp($lista, $arquivo){
        $header = ['Razão Social','Criado'];
        $linhaVazia = ['',''];
        $nome_arquivo = $arquivo . '_' . date("Y-m-d H:i:s") . '.csv';

        CSV::gerarCSV($lista, $header, $linhaVazia, $nome_arquivo);
    
        return $nome_arquivo;
    }

    public function clientes_mhp_completo($lista, $arquivo){
        //cl.nome_fantasia, e.uf, c.email
        $header = ['Cliente','Estado','E-mail'];
        $linhaVazia = ['','',''];
        $nome_arquivo = $arquivo . '_' . date("Y-m-d H:i:s") . '.csv';

        CSV::gerarCSV($lista, $header, $linhaVazia, $nome_arquivo);
    
        return $nome_arquivo;
    }


    
    public function clientes_de_mhp($lista, $arquivo){
       // dominio,contrato_id as contrato, pacote_id as pacote,plano, contas_contratadas, contas_utilizadas, valor, status,ultima_alteracao, created as Data_Criacao, cliente_nome as Nome_Cliente
        $header = ['Dominio','Contrato','Pacote','Plano','Contas Contratadas','Contas Utilizadas','Valor','Status', 'Ultima Alteracao','Data Criacao','Nome Cliente'];
        $linhaVazia = ['','','','','','','','','','',''];
        $nome_arquivo = $arquivo . '_' . date("Y-m-d H:i:s") . '.csv';

        CSV::gerarCSV($lista, $header, $linhaVazia, $nome_arquivo);
    
        return $nome_arquivo;
    }

    public function plesk($lista, $arquivo){
        //cl.nome_fantasia, e.uf, c.email
        $header = ['Cliente','E-mail'];
        $linhaVazia = ['',''];
        $nome_arquivo = $arquivo . '_' . date("Y-m-d H:i:s") . '.csv';

        CSV::gerarCSV($lista, $header, $linhaVazia, $nome_arquivo);
    
        return $nome_arquivo;
    } 


    static function gerarCSV($lista,$header, $linhaVazia, $nome_arquivo){

        $fp = fopen($nome_arquivo, 'w');
        
        fputcsv($fp, $header,';');
        fputcsv($fp, $linhaVazia,';');
        
        foreach($lista as $key)
        {
            fputcsv($fp, $key,';');
        }
    }



}

?>
