<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Uicons</title>

    <style>
        html,body,div,span,applet,object,iframe,h1,h2,h3,h4,h5,h6,p,blockquote,pre,a,abbr,acronym,address,big,cite,code,del,dfn,em,img,ins,kbd,q,s,samp,small,strike,strong,sub,sup,tt,var,b,u,i,center,dl,dt,dd,ol,ul,li,fieldset,form,label,legend,table,caption,tbody,tfoot,thead,tr,th,td,article,aside,canvas,details,embed,figure,figcaption,footer,header,hgroup,menu,nav,output,ruby,section,summary,time,mark,audio,video{margin:0;padding:0;border:0;font-size:100%;font:inherit;vertical-align:baseline}article,aside,details,figcaption,figure,footer,header,hgroup,menu,nav,section{display:block}body{line-height:1}ol,ul{list-style:none}blockquote,q{quotes:none}blockquote:before,blockquote:after,q:before,q:after{content:'';content:none}table{border-collapse:collapse;border-spacing:0}

        html {
            box-sizing: border-box;
        }
        *, *:before, *:after {
            box-sizing: inherit;
        }

        body {
            font-family: Arial, Helvetica, sans-serif;
            color: #4A6375;
            line-height: 22px;
        }

        .container {
            padding: 50px;
        }

        .logo {
            margin-bottom: 50px;
            display: inline-block;
        }

        .logo svg {
            display: block
        }

        h1 {
            font-size: 42px;
            color: #0E2A47;
            font-weight: bold;
            margin-bottom: 40px;
        }

        .mono {
            font-family: Consolas,Monaco,Lucida Console,Liberation Mono,DejaVu Sans Mono,Bitstream Vera Sans Mono,Courier New, monospace;
        }

        code {
            background-color: #1D262D;
            padding: 15px 20px;
            border-radius: 3px;
            color: #fff;
            display: block;
            font-family: Consolas,Monaco,Lucida Console,Liberation Mono,DejaVu Sans Mono,Bitstream Vera Sans Mono,Courier New, monospace;
            font-weight: normal;
            width: 100%;
            max-width: 700px;
            margin-left: -20px;
        }

        pre {
            white-space: break-spaces;
        }

        small {
            font-size: 14px;
            margin-left: -20px;
        }

        ol {
            list-style: decimal;
            padding-left: 20px;
        }

        .steps {
            text-align: left;
            margin-bottom: 40px;;
        }

        .steps ol li {
            margin-bottom: 20px;
        }

        .icons {
            color: #374957;
        }

        .icons {
            display: flex;
            flex-wrap: wrap;
            align-items: flex-start;
            margin: 0 -20px;
        }

        .icons li {
            padding: 0 20px;
            width: 50%;
        }

        .icon-holder {
            height: 62px;
            line-height: 62px;
            border-bottom: 1px solid #CFD9E0;
        }

        .icon-holder i {
            font-size: 32px;
            vertical-align: middle;
            margin-right: 20px;
        }

        @media (max-width: 768px) {
            .container {
                padding: 20px;
            }

            .icons li {
                padding: 0 20px;
                width: 100%;
            }
        }
    </style>

    <link rel="stylesheet" type="text/css" href="css/uicons-bold-rounded.css" />
</head>
<body>

<div class="container">
    <a href="http://www.flaticon.com/uicons" class="logo">
        <svg width="123" height="17" viewBox="0 0 123 17" fill="none" xmlns="http://www.w3.org/2000/svg">
            <g clip-path="url(#clip0)">
                <path d="M29.4438 9.70091C29.4438 14.8009 25.845 17.004 21.812 17.004C17.7791 17.004 14.1641 14.805 14.1641 9.70091V0.434082H18.5135V9.33169C18.5135 11.9162 19.9295 12.9832 21.812 12.9832C23.6946 12.9832 25.1106 11.9324 25.1106 9.33169V0.434082H29.4438V9.70091Z" fill="#222C47"/>
                <path d="M37.1853 16.5821H32.8359V0.434082H37.1853V16.5821Z" fill="#222C47"/>
                <path d="M55.3498 3.051L52.2176 5.68012C51.7982 5.17177 51.2715 4.7626 50.6752 4.482C50.0789 4.2014 49.4279 4.05633 48.7689 4.05721C46.5171 4.05721 44.7116 5.82618 44.7116 8.52021C44.7116 11.2142 46.4968 12.9832 48.7689 12.9832C49.4361 12.977 50.0944 12.8291 50.7001 12.5493C51.3058 12.2695 51.8452 11.8642 52.2825 11.3603L55.3823 14.0097C54.6134 14.9885 53.6254 15.7731 52.4979 16.3002C51.3703 16.8274 50.1348 17.0823 48.8906 17.0446C43.7338 16.9999 40.2852 13.3889 40.2852 8.52021C40.2852 3.65148 43.7338 -7.03519e-05 48.8825 -7.03519e-05C50.1248 -0.0375892 51.3582 0.219274 52.4822 0.74954C53.6062 1.2798 54.5888 2.06843 55.3498 3.051Z" fill="#222C47"/>
                <path d="M73.9959 8.52029C73.9959 13.389 70.2794 17.0406 65.2484 17.0406C60.2174 17.0406 56.5293 13.389 56.5293 8.52029C56.5293 3.65155 60.2295 0 65.2484 0C70.2672 0 73.9959 3.65155 73.9959 8.52029ZM60.9639 8.52029C60.9639 11.1372 62.7978 12.9833 65.2484 12.9833C67.699 12.9833 69.545 11.1494 69.545 8.52029C69.545 5.89117 67.699 4.05728 65.2484 4.05728C62.7978 4.05728 60.9639 5.88305 60.9639 8.52029Z" fill="#222C47"/>
                <path d="M91.7714 6.30095V16.5821H87.422V7.70883C87.422 5.3759 86.2535 4.08974 84.2736 4.08974C82.4072 4.08974 80.8574 5.30692 80.8574 7.74129V16.5821H76.5039V0.434129H80.7397V2.33294C81.8879 0.616706 83.6569 0 85.4908 0C89.1545 0 91.7714 2.54797 91.7714 6.30095Z" fill="#222C47"/>
                <path d="M106.657 4.93353C105.049 4.1464 103.297 3.6976 101.508 3.61492C99.8569 3.61492 99.0252 4.19917 99.0252 5.08365C99.0252 5.96814 100.19 6.24809 101.658 6.46718L103.091 6.68222C106.588 7.21778 108.54 8.78389 108.54 11.5185C108.54 14.8495 105.805 16.9999 101.123 16.9999C98.9238 16.9999 96.039 16.5942 93.9414 15.1011L95.6576 11.7984C97.2818 12.8839 99.2024 13.4395 101.155 13.3889C103.184 13.3889 104.141 12.8209 104.141 11.8715C104.141 11.0884 103.33 10.6543 101.456 10.3865L100.141 10.2039C96.4082 9.68866 94.5581 8.05358 94.5581 5.30275C94.5581 1.98795 97.1223 0.0282822 101.374 0.0282822C103.714 -0.0143955 106.03 0.511905 108.122 1.56193L106.657 4.93353Z" fill="#222C47"/>
                <path d="M3.70114 8.5204L9.24338 2.95787L6.65889 0.377441L1.03145 6.00489C0.37092 6.66732 0 7.56464 0 8.50011C0 9.43559 0.37092 10.3329 1.03145 10.9953L6.60615 16.57L9.19064 13.9896L3.70114 8.5204Z" fill="#4AD295"/>
                <path d="M118.622 8.44737L113.08 13.9896L115.665 16.57L121.288 10.9548C121.616 10.6269 121.876 10.2377 122.054 9.80916C122.232 9.38066 122.323 8.92136 122.323 8.45751C122.323 7.99366 122.232 7.53436 122.054 7.10586C121.876 6.67737 121.616 6.28808 121.288 5.96026L115.713 0.377441L113.133 2.95787L118.622 8.44737Z" fill="#4AD295"/>
            </g>
            <defs>
                <clipPath id="clip0">
                    <rect width="122.323" height="17" fill="white"/>
                </clipPath>
            </defs>
        </svg>
    </a>

    <h1>Get started</h1>

    <div class="steps">
        <ol>
            <li>Copy the entire /webfonts folder and the css into your project’s static assets directory.</li>
            <li>Add the following line into the <span class="mono">&lt;head&gt;</span> of each template or page that you want to use Uicons on.<br><br>
                <code><pre>&lt;link href="/your-path-to-uicons/css/uicons-bold-rounded.css" rel="stylesheet"&gt;</pre></code>
            </li>
            <li>Use the icons with the tags <span class="mono">&lt;i&gt;</span> or <span class="mono">&lt;span&gt;</span>.<br><br>
                <code><pre>&lt;i class="fi fi-br-camera"&gt;
&lt;span class="fi fi-br-camera"&gt;</pre></code>
                <small>Example:</small>
            </li>
        </ol>
    </div>

    <ul class="icons">

            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-add-document"></i>
                    <span class="label mono">fi-br-add-document</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-add-folder"></i>
                    <span class="label mono">fi-br-add-folder</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-add"></i>
                    <span class="label mono">fi-br-add</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-address-book"></i>
                    <span class="label mono">fi-br-address-book</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-alarm-clock"></i>
                    <span class="label mono">fi-br-alarm-clock</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-alarm-plus"></i>
                    <span class="label mono">fi-br-alarm-plus</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-alarm-snooze"></i>
                    <span class="label mono">fi-br-alarm-snooze</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-align-center"></i>
                    <span class="label mono">fi-br-align-center</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-align-justify"></i>
                    <span class="label mono">fi-br-align-justify</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-align-left"></i>
                    <span class="label mono">fi-br-align-left</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-align-right"></i>
                    <span class="label mono">fi-br-align-right</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-ambulance"></i>
                    <span class="label mono">fi-br-ambulance</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-angle-circle-down"></i>
                    <span class="label mono">fi-br-angle-circle-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-angle-circle-left"></i>
                    <span class="label mono">fi-br-angle-circle-left</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-angle-circle-right"></i>
                    <span class="label mono">fi-br-angle-circle-right</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-angle-circle-up"></i>
                    <span class="label mono">fi-br-angle-circle-up</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-angle-double-left"></i>
                    <span class="label mono">fi-br-angle-double-left</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-angle-double-right"></i>
                    <span class="label mono">fi-br-angle-double-right</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-angle-double-small-down"></i>
                    <span class="label mono">fi-br-angle-double-small-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-angle-double-small-left"></i>
                    <span class="label mono">fi-br-angle-double-small-left</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-angle-double-small-right"></i>
                    <span class="label mono">fi-br-angle-double-small-right</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-angle-double-small-up"></i>
                    <span class="label mono">fi-br-angle-double-small-up</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-angle-down"></i>
                    <span class="label mono">fi-br-angle-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-angle-left"></i>
                    <span class="label mono">fi-br-angle-left</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-angle-right"></i>
                    <span class="label mono">fi-br-angle-right</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-angle-small-down"></i>
                    <span class="label mono">fi-br-angle-small-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-angle-small-left"></i>
                    <span class="label mono">fi-br-angle-small-left</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-angle-small-right"></i>
                    <span class="label mono">fi-br-angle-small-right</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-angle-small-up"></i>
                    <span class="label mono">fi-br-angle-small-up</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-angle-square-down"></i>
                    <span class="label mono">fi-br-angle-square-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-angle-square-left"></i>
                    <span class="label mono">fi-br-angle-square-left</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-angle-square-right"></i>
                    <span class="label mono">fi-br-angle-square-right</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-angle-square-up"></i>
                    <span class="label mono">fi-br-angle-square-up</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-angle-up"></i>
                    <span class="label mono">fi-br-angle-up</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-angry"></i>
                    <span class="label mono">fi-br-angry</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-apple-whole"></i>
                    <span class="label mono">fi-br-apple-whole</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-apps-add"></i>
                    <span class="label mono">fi-br-apps-add</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-apps-delete"></i>
                    <span class="label mono">fi-br-apps-delete</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-apps-sort"></i>
                    <span class="label mono">fi-br-apps-sort</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-apps"></i>
                    <span class="label mono">fi-br-apps</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-archive"></i>
                    <span class="label mono">fi-br-archive</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-alt-circle-down"></i>
                    <span class="label mono">fi-br-arrow-alt-circle-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-alt-circle-left"></i>
                    <span class="label mono">fi-br-arrow-alt-circle-left</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-alt-circle-right"></i>
                    <span class="label mono">fi-br-arrow-alt-circle-right</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-alt-circle-up"></i>
                    <span class="label mono">fi-br-arrow-alt-circle-up</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-alt-down"></i>
                    <span class="label mono">fi-br-arrow-alt-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-alt-from-bottom"></i>
                    <span class="label mono">fi-br-arrow-alt-from-bottom</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-alt-from-left"></i>
                    <span class="label mono">fi-br-arrow-alt-from-left</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-alt-from-right"></i>
                    <span class="label mono">fi-br-arrow-alt-from-right</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-alt-from-top"></i>
                    <span class="label mono">fi-br-arrow-alt-from-top</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-alt-left"></i>
                    <span class="label mono">fi-br-arrow-alt-left</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-alt-right"></i>
                    <span class="label mono">fi-br-arrow-alt-right</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-alt-square-down"></i>
                    <span class="label mono">fi-br-arrow-alt-square-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-alt-square-left"></i>
                    <span class="label mono">fi-br-arrow-alt-square-left</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-alt-square-right"></i>
                    <span class="label mono">fi-br-arrow-alt-square-right</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-alt-square-up"></i>
                    <span class="label mono">fi-br-arrow-alt-square-up</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-alt-to-bottom"></i>
                    <span class="label mono">fi-br-arrow-alt-to-bottom</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-alt-to-left"></i>
                    <span class="label mono">fi-br-arrow-alt-to-left</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-alt-to-right"></i>
                    <span class="label mono">fi-br-arrow-alt-to-right</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-alt-to-top"></i>
                    <span class="label mono">fi-br-arrow-alt-to-top</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-alt-up"></i>
                    <span class="label mono">fi-br-arrow-alt-up</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-circle-down"></i>
                    <span class="label mono">fi-br-arrow-circle-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-circle-left"></i>
                    <span class="label mono">fi-br-arrow-circle-left</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-circle-right"></i>
                    <span class="label mono">fi-br-arrow-circle-right</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-circle-up"></i>
                    <span class="label mono">fi-br-arrow-circle-up</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-down"></i>
                    <span class="label mono">fi-br-arrow-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-from-bottom"></i>
                    <span class="label mono">fi-br-arrow-from-bottom</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-from-left"></i>
                    <span class="label mono">fi-br-arrow-from-left</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-from-right"></i>
                    <span class="label mono">fi-br-arrow-from-right</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-from-top"></i>
                    <span class="label mono">fi-br-arrow-from-top</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-left"></i>
                    <span class="label mono">fi-br-arrow-left</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-right"></i>
                    <span class="label mono">fi-br-arrow-right</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-small-down"></i>
                    <span class="label mono">fi-br-arrow-small-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-small-left"></i>
                    <span class="label mono">fi-br-arrow-small-left</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-small-right"></i>
                    <span class="label mono">fi-br-arrow-small-right</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-small-up"></i>
                    <span class="label mono">fi-br-arrow-small-up</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-square-down"></i>
                    <span class="label mono">fi-br-arrow-square-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-square-left"></i>
                    <span class="label mono">fi-br-arrow-square-left</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-square-right"></i>
                    <span class="label mono">fi-br-arrow-square-right</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-square-up"></i>
                    <span class="label mono">fi-br-arrow-square-up</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-to-bottom"></i>
                    <span class="label mono">fi-br-arrow-to-bottom</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-to-left"></i>
                    <span class="label mono">fi-br-arrow-to-left</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-to-right"></i>
                    <span class="label mono">fi-br-arrow-to-right</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-to-top"></i>
                    <span class="label mono">fi-br-arrow-to-top</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrow-up"></i>
                    <span class="label mono">fi-br-arrow-up</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrows-alt-h"></i>
                    <span class="label mono">fi-br-arrows-alt-h</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrows-alt-v"></i>
                    <span class="label mono">fi-br-arrows-alt-v</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrows-alt"></i>
                    <span class="label mono">fi-br-arrows-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrows-h-copy"></i>
                    <span class="label mono">fi-br-arrows-h-copy</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrows-h"></i>
                    <span class="label mono">fi-br-arrows-h</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-arrows"></i>
                    <span class="label mono">fi-br-arrows</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-assept-document"></i>
                    <span class="label mono">fi-br-assept-document</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-assistive-listening-systems"></i>
                    <span class="label mono">fi-br-assistive-listening-systems</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-asterik"></i>
                    <span class="label mono">fi-br-asterik</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-astonished-face"></i>
                    <span class="label mono">fi-br-astonished-face</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-at"></i>
                    <span class="label mono">fi-br-at</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-aubergine"></i>
                    <span class="label mono">fi-br-aubergine</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-avocado"></i>
                    <span class="label mono">fi-br-avocado</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-baby-carriage"></i>
                    <span class="label mono">fi-br-baby-carriage</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-backpack"></i>
                    <span class="label mono">fi-br-backpack</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-bacon"></i>
                    <span class="label mono">fi-br-bacon</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-badge"></i>
                    <span class="label mono">fi-br-badge</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-balloons"></i>
                    <span class="label mono">fi-br-balloons</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-ban"></i>
                    <span class="label mono">fi-br-ban</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-band-aid"></i>
                    <span class="label mono">fi-br-band-aid</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-bank"></i>
                    <span class="label mono">fi-br-bank</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-barber-shop"></i>
                    <span class="label mono">fi-br-barber-shop</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-baseball-alt"></i>
                    <span class="label mono">fi-br-baseball-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-baseball"></i>
                    <span class="label mono">fi-br-baseball</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-basketball-hoop"></i>
                    <span class="label mono">fi-br-basketball-hoop</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-basketball"></i>
                    <span class="label mono">fi-br-basketball</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-bed"></i>
                    <span class="label mono">fi-br-bed</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-beer"></i>
                    <span class="label mono">fi-br-beer</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-bell-ring"></i>
                    <span class="label mono">fi-br-bell-ring</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-bell-school"></i>
                    <span class="label mono">fi-br-bell-school</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-bell"></i>
                    <span class="label mono">fi-br-bell</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-bike"></i>
                    <span class="label mono">fi-br-bike</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-biking-mountain"></i>
                    <span class="label mono">fi-br-biking-mountain</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-biking"></i>
                    <span class="label mono">fi-br-biking</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-billiard"></i>
                    <span class="label mono">fi-br-billiard</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-bold"></i>
                    <span class="label mono">fi-br-bold</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-bolt"></i>
                    <span class="label mono">fi-br-bolt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-book-alt"></i>
                    <span class="label mono">fi-br-book-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-book"></i>
                    <span class="label mono">fi-br-book</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-bookmark"></i>
                    <span class="label mono">fi-br-bookmark</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-bottle"></i>
                    <span class="label mono">fi-br-bottle</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-bow-arrow"></i>
                    <span class="label mono">fi-br-bow-arrow</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-bowling-ball"></i>
                    <span class="label mono">fi-br-bowling-ball</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-bowling-pins"></i>
                    <span class="label mono">fi-br-bowling-pins</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-bowling"></i>
                    <span class="label mono">fi-br-bowling</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-box-alt"></i>
                    <span class="label mono">fi-br-box-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-box"></i>
                    <span class="label mono">fi-br-box</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-boxing-glove"></i>
                    <span class="label mono">fi-br-boxing-glove</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-braille"></i>
                    <span class="label mono">fi-br-braille</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-bread-slice"></i>
                    <span class="label mono">fi-br-bread-slice</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-bread"></i>
                    <span class="label mono">fi-br-bread</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-briefcase"></i>
                    <span class="label mono">fi-br-briefcase</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-broccoli"></i>
                    <span class="label mono">fi-br-broccoli</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-broom"></i>
                    <span class="label mono">fi-br-broom</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-browser"></i>
                    <span class="label mono">fi-br-browser</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-brush"></i>
                    <span class="label mono">fi-br-brush</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-bug"></i>
                    <span class="label mono">fi-br-bug</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-building"></i>
                    <span class="label mono">fi-br-building</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-bulb"></i>
                    <span class="label mono">fi-br-bulb</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-burrito"></i>
                    <span class="label mono">fi-br-burrito</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-bus-alt"></i>
                    <span class="label mono">fi-br-bus-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-bus"></i>
                    <span class="label mono">fi-br-bus</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-butterfly"></i>
                    <span class="label mono">fi-br-butterfly</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cake-birthday"></i>
                    <span class="label mono">fi-br-cake-birthday</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cake-wedding"></i>
                    <span class="label mono">fi-br-cake-wedding</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-calculator"></i>
                    <span class="label mono">fi-br-calculator</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-calendar-check"></i>
                    <span class="label mono">fi-br-calendar-check</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-calendar-clock"></i>
                    <span class="label mono">fi-br-calendar-clock</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-calendar-exclamation"></i>
                    <span class="label mono">fi-br-calendar-exclamation</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-calendar-lines-pen"></i>
                    <span class="label mono">fi-br-calendar-lines-pen</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-calendar-lines"></i>
                    <span class="label mono">fi-br-calendar-lines</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-calendar-minus"></i>
                    <span class="label mono">fi-br-calendar-minus</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-calendar-pen"></i>
                    <span class="label mono">fi-br-calendar-pen</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-calendar-plus"></i>
                    <span class="label mono">fi-br-calendar-plus</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-calendar"></i>
                    <span class="label mono">fi-br-calendar</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-call-history"></i>
                    <span class="label mono">fi-br-call-history</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-call-incoming"></i>
                    <span class="label mono">fi-br-call-incoming</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-call-missed"></i>
                    <span class="label mono">fi-br-call-missed</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-call-outgoing"></i>
                    <span class="label mono">fi-br-call-outgoing</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-camera"></i>
                    <span class="label mono">fi-br-camera</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-camping"></i>
                    <span class="label mono">fi-br-camping</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-candy-alt"></i>
                    <span class="label mono">fi-br-candy-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-candy"></i>
                    <span class="label mono">fi-br-candy</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-canned-food"></i>
                    <span class="label mono">fi-br-canned-food</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-car-alt"></i>
                    <span class="label mono">fi-br-car-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-car-battery"></i>
                    <span class="label mono">fi-br-car-battery</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-car-building"></i>
                    <span class="label mono">fi-br-car-building</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-car-bump"></i>
                    <span class="label mono">fi-br-car-bump</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-car-bus"></i>
                    <span class="label mono">fi-br-car-bus</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-car-crash"></i>
                    <span class="label mono">fi-br-car-crash</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-car-garage"></i>
                    <span class="label mono">fi-br-car-garage</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-car-mechanic"></i>
                    <span class="label mono">fi-br-car-mechanic</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-car-side"></i>
                    <span class="label mono">fi-br-car-side</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-car-tilt"></i>
                    <span class="label mono">fi-br-car-tilt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-car-wash"></i>
                    <span class="label mono">fi-br-car-wash</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-car"></i>
                    <span class="label mono">fi-br-car</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-caravan-alt"></i>
                    <span class="label mono">fi-br-caravan-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-caravan"></i>
                    <span class="label mono">fi-br-caravan</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-care"></i>
                    <span class="label mono">fi-br-care</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-caret-circle-down"></i>
                    <span class="label mono">fi-br-caret-circle-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-caret-circle-right"></i>
                    <span class="label mono">fi-br-caret-circle-right</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-caret-circle-up"></i>
                    <span class="label mono">fi-br-caret-circle-up</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-caret-down"></i>
                    <span class="label mono">fi-br-caret-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-caret-left"></i>
                    <span class="label mono">fi-br-caret-left</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-caret-quare-up"></i>
                    <span class="label mono">fi-br-caret-quare-up</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-caret-right"></i>
                    <span class="label mono">fi-br-caret-right</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-caret-square-down"></i>
                    <span class="label mono">fi-br-caret-square-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-caret-square-left_1"></i>
                    <span class="label mono">fi-br-caret-square-left_1</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-caret-square-left"></i>
                    <span class="label mono">fi-br-caret-square-left</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-caret-square-right"></i>
                    <span class="label mono">fi-br-caret-square-right</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-caret-up"></i>
                    <span class="label mono">fi-br-caret-up</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-carrot"></i>
                    <span class="label mono">fi-br-carrot</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cars"></i>
                    <span class="label mono">fi-br-cars</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-charging-station"></i>
                    <span class="label mono">fi-br-charging-station</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chart-connected"></i>
                    <span class="label mono">fi-br-chart-connected</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chart-histogram"></i>
                    <span class="label mono">fi-br-chart-histogram</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chart-network"></i>
                    <span class="label mono">fi-br-chart-network</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chart-pie-alt"></i>
                    <span class="label mono">fi-br-chart-pie-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chart-pie"></i>
                    <span class="label mono">fi-br-chart-pie</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chart-pyramid"></i>
                    <span class="label mono">fi-br-chart-pyramid</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chart-set-theory"></i>
                    <span class="label mono">fi-br-chart-set-theory</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chart-tree"></i>
                    <span class="label mono">fi-br-chart-tree</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chat-arrow-down"></i>
                    <span class="label mono">fi-br-chat-arrow-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chat-arrow-grow"></i>
                    <span class="label mono">fi-br-chat-arrow-grow</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-check"></i>
                    <span class="label mono">fi-br-check</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-checkbox"></i>
                    <span class="label mono">fi-br-checkbox</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cheese"></i>
                    <span class="label mono">fi-br-cheese</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cherry"></i>
                    <span class="label mono">fi-br-cherry</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chess-piece"></i>
                    <span class="label mono">fi-br-chess-piece</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chess-bishop"></i>
                    <span class="label mono">fi-br-chess-bishop</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chess-board"></i>
                    <span class="label mono">fi-br-chess-board</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chess-clock-alt"></i>
                    <span class="label mono">fi-br-chess-clock-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chess-clock"></i>
                    <span class="label mono">fi-br-chess-clock</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chess-king-alt"></i>
                    <span class="label mono">fi-br-chess-king-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chess-king"></i>
                    <span class="label mono">fi-br-chess-king</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chess-knight-alt"></i>
                    <span class="label mono">fi-br-chess-knight-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chess-knight"></i>
                    <span class="label mono">fi-br-chess-knight</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chess-pawn-alt"></i>
                    <span class="label mono">fi-br-chess-pawn-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chess-pawn"></i>
                    <span class="label mono">fi-br-chess-pawn</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chess-queen-alt"></i>
                    <span class="label mono">fi-br-chess-queen-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chess-queen"></i>
                    <span class="label mono">fi-br-chess-queen</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chess-rook-alt"></i>
                    <span class="label mono">fi-br-chess-rook-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chess-rook"></i>
                    <span class="label mono">fi-br-chess-rook</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chess"></i>
                    <span class="label mono">fi-br-chess</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chevron-double-down"></i>
                    <span class="label mono">fi-br-chevron-double-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chevron-double-up"></i>
                    <span class="label mono">fi-br-chevron-double-up</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-child-head"></i>
                    <span class="label mono">fi-br-child-head</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-chocolate"></i>
                    <span class="label mono">fi-br-chocolate</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-circle-small"></i>
                    <span class="label mono">fi-br-circle-small</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-circle"></i>
                    <span class="label mono">fi-br-circle</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clip"></i>
                    <span class="label mono">fi-br-clip</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clock-eight-thirty"></i>
                    <span class="label mono">fi-br-clock-eight-thirty</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clock-eleven-thirty"></i>
                    <span class="label mono">fi-br-clock-eleven-thirty</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clock-eleven"></i>
                    <span class="label mono">fi-br-clock-eleven</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clock-five-thirty"></i>
                    <span class="label mono">fi-br-clock-five-thirty</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clock-five"></i>
                    <span class="label mono">fi-br-clock-five</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clock-four-thirty"></i>
                    <span class="label mono">fi-br-clock-four-thirty</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clock-nine-thirty"></i>
                    <span class="label mono">fi-br-clock-nine-thirty</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clock-nine"></i>
                    <span class="label mono">fi-br-clock-nine</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clock-one-thirty"></i>
                    <span class="label mono">fi-br-clock-one-thirty</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clock-one"></i>
                    <span class="label mono">fi-br-clock-one</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clock-seven-thirty"></i>
                    <span class="label mono">fi-br-clock-seven-thirty</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clock-seven"></i>
                    <span class="label mono">fi-br-clock-seven</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clock-six-thirty"></i>
                    <span class="label mono">fi-br-clock-six-thirty</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clock-six"></i>
                    <span class="label mono">fi-br-clock-six</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clock-ten-thirty"></i>
                    <span class="label mono">fi-br-clock-ten-thirty</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clock-ten"></i>
                    <span class="label mono">fi-br-clock-ten</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clock-three-thirty"></i>
                    <span class="label mono">fi-br-clock-three-thirty</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clock-three"></i>
                    <span class="label mono">fi-br-clock-three</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clock-twelve-thirty"></i>
                    <span class="label mono">fi-br-clock-twelve-thirty</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clock-twelve"></i>
                    <span class="label mono">fi-br-clock-twelve</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clock-two-thirty"></i>
                    <span class="label mono">fi-br-clock-two-thirty</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clock-two"></i>
                    <span class="label mono">fi-br-clock-two</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clock"></i>
                    <span class="label mono">fi-br-clock</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cloud-upload"></i>
                    <span class="label mono">fi-br-cloud-upload</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cloud-check"></i>
                    <span class="label mono">fi-br-cloud-check</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cloud-disabled"></i>
                    <span class="label mono">fi-br-cloud-disabled</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cloud-download-alt"></i>
                    <span class="label mono">fi-br-cloud-download-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cloud-download"></i>
                    <span class="label mono">fi-br-cloud-download</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cloud-drizzle"></i>
                    <span class="label mono">fi-br-cloud-drizzle</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cloud-hail-mixed"></i>
                    <span class="label mono">fi-br-cloud-hail-mixed</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cloud-hail"></i>
                    <span class="label mono">fi-br-cloud-hail</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cloud-moon-rain"></i>
                    <span class="label mono">fi-br-cloud-moon-rain</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cloud-moon"></i>
                    <span class="label mono">fi-br-cloud-moon</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cloud-rain"></i>
                    <span class="label mono">fi-br-cloud-rain</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cloud-rainbow"></i>
                    <span class="label mono">fi-br-cloud-rainbow</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cloud-share"></i>
                    <span class="label mono">fi-br-cloud-share</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cloud-showers-heavy"></i>
                    <span class="label mono">fi-br-cloud-showers-heavy</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cloud-showers"></i>
                    <span class="label mono">fi-br-cloud-showers</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cloud-sleet"></i>
                    <span class="label mono">fi-br-cloud-sleet</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cloud-snow"></i>
                    <span class="label mono">fi-br-cloud-snow</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cloud-sun-rain"></i>
                    <span class="label mono">fi-br-cloud-sun-rain</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cloud-sun"></i>
                    <span class="label mono">fi-br-cloud-sun</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cloud-upload-alt"></i>
                    <span class="label mono">fi-br-cloud-upload-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cloud"></i>
                    <span class="label mono">fi-br-cloud</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clouds-moon"></i>
                    <span class="label mono">fi-br-clouds-moon</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clouds-sun"></i>
                    <span class="label mono">fi-br-clouds-sun</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-clouds"></i>
                    <span class="label mono">fi-br-clouds</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-club"></i>
                    <span class="label mono">fi-br-club</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cocktail-alt"></i>
                    <span class="label mono">fi-br-cocktail-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cocktail"></i>
                    <span class="label mono">fi-br-cocktail</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-coffee-pot"></i>
                    <span class="label mono">fi-br-coffee-pot</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-coffee"></i>
                    <span class="label mono">fi-br-coffee</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-comment-alt"></i>
                    <span class="label mono">fi-br-comment-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-comment-check"></i>
                    <span class="label mono">fi-br-comment-check</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-comment-heart"></i>
                    <span class="label mono">fi-br-comment-heart</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-comment-info"></i>
                    <span class="label mono">fi-br-comment-info</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-comment-user"></i>
                    <span class="label mono">fi-br-comment-user</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-comment"></i>
                    <span class="label mono">fi-br-comment</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-comments"></i>
                    <span class="label mono">fi-br-comments</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-compress-alt"></i>
                    <span class="label mono">fi-br-compress-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-compress"></i>
                    <span class="label mono">fi-br-compress</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-computer"></i>
                    <span class="label mono">fi-br-computer</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-confetti"></i>
                    <span class="label mono">fi-br-confetti</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cookie"></i>
                    <span class="label mono">fi-br-cookie</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-copy-alt"></i>
                    <span class="label mono">fi-br-copy-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-copy"></i>
                    <span class="label mono">fi-br-copy</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-copyright"></i>
                    <span class="label mono">fi-br-copyright</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-corn"></i>
                    <span class="label mono">fi-br-corn</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-couple"></i>
                    <span class="label mono">fi-br-couple</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cow"></i>
                    <span class="label mono">fi-br-cow</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cream"></i>
                    <span class="label mono">fi-br-cream</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-credit-Domain"></i>
                    <span class="label mono">fi-br-credit-Domain</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cricket"></i>
                    <span class="label mono">fi-br-cricket</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-croissant"></i>
                    <span class="label mono">fi-br-croissant</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cross-circle"></i>
                    <span class="label mono">fi-br-cross-circle</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cross-small"></i>
                    <span class="label mono">fi-br-cross-small</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cross"></i>
                    <span class="label mono">fi-br-cross</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-crown"></i>
                    <span class="label mono">fi-br-crown</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cube"></i>
                    <span class="label mono">fi-br-cube</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cupcake"></i>
                    <span class="label mono">fi-br-cupcake</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-curling"></i>
                    <span class="label mono">fi-br-curling</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cursor-finger"></i>
                    <span class="label mono">fi-br-cursor-finger</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cursor-plus"></i>
                    <span class="label mono">fi-br-cursor-plus</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cursor-text-alt"></i>
                    <span class="label mono">fi-br-cursor-text-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cursor-text"></i>
                    <span class="label mono">fi-br-cursor-text</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-cursor"></i>
                    <span class="label mono">fi-br-cursor</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-dart"></i>
                    <span class="label mono">fi-br-dart</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-dashboard"></i>
                    <span class="label mono">fi-br-dashboard</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-data-transfer"></i>
                    <span class="label mono">fi-br-data-transfer</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-database"></i>
                    <span class="label mono">fi-br-database</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-delete-document"></i>
                    <span class="label mono">fi-br-delete-document</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-delete-user"></i>
                    <span class="label mono">fi-br-delete-user</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-delete"></i>
                    <span class="label mono">fi-br-delete</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-dewpoint"></i>
                    <span class="label mono">fi-br-dewpoint</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-diamond"></i>
                    <span class="label mono">fi-br-diamond</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-dice-alt"></i>
                    <span class="label mono">fi-br-dice-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-dice-d10"></i>
                    <span class="label mono">fi-br-dice-d10</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-dice-d12"></i>
                    <span class="label mono">fi-br-dice-d12</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-dice-d20"></i>
                    <span class="label mono">fi-br-dice-d20</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-dice-d4"></i>
                    <span class="label mono">fi-br-dice-d4</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-dice-d6"></i>
                    <span class="label mono">fi-br-dice-d6</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-dice-d8"></i>
                    <span class="label mono">fi-br-dice-d8</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-dice-four"></i>
                    <span class="label mono">fi-br-dice-four</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-dice-one"></i>
                    <span class="label mono">fi-br-dice-one</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-dice-six"></i>
                    <span class="label mono">fi-br-dice-six</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-dice-three"></i>
                    <span class="label mono">fi-br-dice-three</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-dice-two"></i>
                    <span class="label mono">fi-br-dice-two</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-dice"></i>
                    <span class="label mono">fi-br-dice</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-diploma"></i>
                    <span class="label mono">fi-br-diploma</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-disco-ball"></i>
                    <span class="label mono">fi-br-disco-ball</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-disk"></i>
                    <span class="label mono">fi-br-disk</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-dizzy"></i>
                    <span class="label mono">fi-br-dizzy</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-doctor"></i>
                    <span class="label mono">fi-br-doctor</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-document-signed"></i>
                    <span class="label mono">fi-br-document-signed</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-document"></i>
                    <span class="label mono">fi-br-document</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-dollar"></i>
                    <span class="label mono">fi-br-dollar</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-download"></i>
                    <span class="label mono">fi-br-download</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-dreidel"></i>
                    <span class="label mono">fi-br-dreidel</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-drink-alt"></i>
                    <span class="label mono">fi-br-drink-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-drumstick"></i>
                    <span class="label mono">fi-br-drumstick</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-duplicate"></i>
                    <span class="label mono">fi-br-duplicate</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-e-learning"></i>
                    <span class="label mono">fi-br-e-learning</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-earnings"></i>
                    <span class="label mono">fi-br-earnings</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-eclipse-alt"></i>
                    <span class="label mono">fi-br-eclipse-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-eclipse"></i>
                    <span class="label mono">fi-br-eclipse</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-edit-alt"></i>
                    <span class="label mono">fi-br-edit-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-edit"></i>
                    <span class="label mono">fi-br-edit</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-egg-fried"></i>
                    <span class="label mono">fi-br-egg-fried</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-egg"></i>
                    <span class="label mono">fi-br-egg</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-engine-warning"></i>
                    <span class="label mono">fi-br-engine-warning</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-envelope-ban"></i>
                    <span class="label mono">fi-br-envelope-ban</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-envelope-download"></i>
                    <span class="label mono">fi-br-envelope-download</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-envelope-marker"></i>
                    <span class="label mono">fi-br-envelope-marker</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-envelope-open"></i>
                    <span class="label mono">fi-br-envelope-open</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-envelope-plus"></i>
                    <span class="label mono">fi-br-envelope-plus</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-envelope"></i>
                    <span class="label mono">fi-br-envelope</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-euro"></i>
                    <span class="label mono">fi-br-euro</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-exchange-alt"></i>
                    <span class="label mono">fi-br-exchange-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-exchange"></i>
                    <span class="label mono">fi-br-exchange</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-exclamation"></i>
                    <span class="label mono">fi-br-exclamation</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-expand-arrows-alt"></i>
                    <span class="label mono">fi-br-expand-arrows-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-expand-arrows"></i>
                    <span class="label mono">fi-br-expand-arrows</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-expand"></i>
                    <span class="label mono">fi-br-expand</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-eye-crossed"></i>
                    <span class="label mono">fi-br-eye-crossed</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-eye-dropper"></i>
                    <span class="label mono">fi-br-eye-dropper</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-eye"></i>
                    <span class="label mono">fi-br-eye</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-feather"></i>
                    <span class="label mono">fi-br-feather</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-female-couple"></i>
                    <span class="label mono">fi-br-female-couple</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-female"></i>
                    <span class="label mono">fi-br-female</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-ferris-wheel"></i>
                    <span class="label mono">fi-br-ferris-wheel</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-field-hockey"></i>
                    <span class="label mono">fi-br-field-hockey</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-fighter-jet"></i>
                    <span class="label mono">fi-br-fighter-jet</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-file-ai"></i>
                    <span class="label mono">fi-br-file-ai</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-file-eps"></i>
                    <span class="label mono">fi-br-file-eps</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-file-psd"></i>
                    <span class="label mono">fi-br-file-psd</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-file"></i>
                    <span class="label mono">fi-br-file</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-fill"></i>
                    <span class="label mono">fi-br-fill</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-film"></i>
                    <span class="label mono">fi-br-film</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-filter"></i>
                    <span class="label mono">fi-br-filter</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-fingerprint"></i>
                    <span class="label mono">fi-br-fingerprint</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-fish"></i>
                    <span class="label mono">fi-br-fish</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-flag"></i>
                    <span class="label mono">fi-br-flag</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-flame"></i>
                    <span class="label mono">fi-br-flame</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-flip-horizontal"></i>
                    <span class="label mono">fi-br-flip-horizontal</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-flower-bouquet"></i>
                    <span class="label mono">fi-br-flower-bouquet</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-flower-tulip"></i>
                    <span class="label mono">fi-br-flower-tulip</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-flower"></i>
                    <span class="label mono">fi-br-flower</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-flushed-face"></i>
                    <span class="label mono">fi-br-flushed-face</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-flushed"></i>
                    <span class="label mono">fi-br-flushed</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-fog"></i>
                    <span class="label mono">fi-br-fog</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-folder"></i>
                    <span class="label mono">fi-br-folder</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-following"></i>
                    <span class="label mono">fi-br-following</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-football"></i>
                    <span class="label mono">fi-br-football</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-fork"></i>
                    <span class="label mono">fi-br-fork</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-form"></i>
                    <span class="label mono">fi-br-form</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-forward"></i>
                    <span class="label mono">fi-br-forward</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-fox"></i>
                    <span class="label mono">fi-br-fox</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-french-fries"></i>
                    <span class="label mono">fi-br-french-fries</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-ftp"></i>
                    <span class="label mono">fi-br-ftp</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-gallery"></i>
                    <span class="label mono">fi-br-gallery</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-game-board-alt"></i>
                    <span class="label mono">fi-br-game-board-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-gamepad"></i>
                    <span class="label mono">fi-br-gamepad</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-garage-car"></i>
                    <span class="label mono">fi-br-garage-car</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-garage-open"></i>
                    <span class="label mono">fi-br-garage-open</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-garage"></i>
                    <span class="label mono">fi-br-garage</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-garlic"></i>
                    <span class="label mono">fi-br-garlic</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-gas-pump-alt"></i>
                    <span class="label mono">fi-br-gas-pump-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-gas-pump-slash"></i>
                    <span class="label mono">fi-br-gas-pump-slash</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-gas-pump"></i>
                    <span class="label mono">fi-br-gas-pump</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-gem"></i>
                    <span class="label mono">fi-br-gem</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-gif"></i>
                    <span class="label mono">fi-br-gif</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-gift"></i>
                    <span class="label mono">fi-br-gift</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-gingerbread-man"></i>
                    <span class="label mono">fi-br-gingerbread-man</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-glass-cheers"></i>
                    <span class="label mono">fi-br-glass-cheers</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-glass"></i>
                    <span class="label mono">fi-br-glass</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-glasses"></i>
                    <span class="label mono">fi-br-glasses</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-globe-alt"></i>
                    <span class="label mono">fi-br-globe-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-globe"></i>
                    <span class="label mono">fi-br-globe</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-golf-ball"></i>
                    <span class="label mono">fi-br-golf-ball</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-golf-club"></i>
                    <span class="label mono">fi-br-golf-club</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-golf"></i>
                    <span class="label mono">fi-br-golf</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-graduation-cap"></i>
                    <span class="label mono">fi-br-graduation-cap</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-grape"></i>
                    <span class="label mono">fi-br-grape</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-graphic-tablet"></i>
                    <span class="label mono">fi-br-graphic-tablet</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-grid-alt"></i>
                    <span class="label mono">fi-br-grid-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-grid"></i>
                    <span class="label mono">fi-br-grid</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-grill"></i>
                    <span class="label mono">fi-br-grill</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-grimace"></i>
                    <span class="label mono">fi-br-grimace</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-grin-alt"></i>
                    <span class="label mono">fi-br-grin-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-grin-beam-sweat"></i>
                    <span class="label mono">fi-br-grin-beam-sweat</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-grin-beam"></i>
                    <span class="label mono">fi-br-grin-beam</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-grin-hearts"></i>
                    <span class="label mono">fi-br-grin-hearts</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-grin-squint-tears"></i>
                    <span class="label mono">fi-br-grin-squint-tears</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-grin-squint"></i>
                    <span class="label mono">fi-br-grin-squint</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-grin-stars"></i>
                    <span class="label mono">fi-br-grin-stars</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-grin-tears"></i>
                    <span class="label mono">fi-br-grin-tears</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-grin-tongue-squint"></i>
                    <span class="label mono">fi-br-grin-tongue-squint</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-grin-tongue-wink"></i>
                    <span class="label mono">fi-br-grin-tongue-wink</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-grin-tongue"></i>
                    <span class="label mono">fi-br-grin-tongue</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-grin-wink"></i>
                    <span class="label mono">fi-br-grin-wink</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-grin"></i>
                    <span class="label mono">fi-br-grin</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-guitar"></i>
                    <span class="label mono">fi-br-guitar</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-gym"></i>
                    <span class="label mono">fi-br-gym</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-hamburger-soda"></i>
                    <span class="label mono">fi-br-hamburger-soda</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-hamburger"></i>
                    <span class="label mono">fi-br-hamburger</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-happy"></i>
                    <span class="label mono">fi-br-happy</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-hastag"></i>
                    <span class="label mono">fi-br-hastag</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-hat-birthday"></i>
                    <span class="label mono">fi-br-hat-birthday</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-hat-chef"></i>
                    <span class="label mono">fi-br-hat-chef</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-head-side-thinking"></i>
                    <span class="label mono">fi-br-head-side-thinking</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-headphones"></i>
                    <span class="label mono">fi-br-headphones</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-headset"></i>
                    <span class="label mono">fi-br-headset</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-heart-arrow"></i>
                    <span class="label mono">fi-br-heart-arrow</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-heart"></i>
                    <span class="label mono">fi-br-heart</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-heat"></i>
                    <span class="label mono">fi-br-heat</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-helicopter-side"></i>
                    <span class="label mono">fi-br-helicopter-side</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-hiking"></i>
                    <span class="label mono">fi-br-hiking</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-hockey-mask"></i>
                    <span class="label mono">fi-br-hockey-mask</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-hockey-puck"></i>
                    <span class="label mono">fi-br-hockey-puck</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-hockey-sticks"></i>
                    <span class="label mono">fi-br-hockey-sticks</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-home-location-alt"></i>
                    <span class="label mono">fi-br-home-location-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-home-location"></i>
                    <span class="label mono">fi-br-home-location</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-home"></i>
                    <span class="label mono">fi-br-home</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-hotdog"></i>
                    <span class="label mono">fi-br-hotdog</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-hourglass-end"></i>
                    <span class="label mono">fi-br-hourglass-end</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-hourglass"></i>
                    <span class="label mono">fi-br-hourglass</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-house-flood"></i>
                    <span class="label mono">fi-br-house-flood</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-humidity"></i>
                    <span class="label mono">fi-br-humidity</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-hurricane"></i>
                    <span class="label mono">fi-br-hurricane</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-ice-cream"></i>
                    <span class="label mono">fi-br-ice-cream</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-ice-skate"></i>
                    <span class="label mono">fi-br-ice-skate</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-id-badge"></i>
                    <span class="label mono">fi-br-id-badge</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-inbox-in"></i>
                    <span class="label mono">fi-br-inbox-in</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-inbox-out"></i>
                    <span class="label mono">fi-br-inbox-out</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-inbox"></i>
                    <span class="label mono">fi-br-inbox</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-incognito"></i>
                    <span class="label mono">fi-br-incognito</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-indent"></i>
                    <span class="label mono">fi-br-indent</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-infinity"></i>
                    <span class="label mono">fi-br-infinity</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-info"></i>
                    <span class="label mono">fi-br-info</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-interactive"></i>
                    <span class="label mono">fi-br-interactive</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-interlining"></i>
                    <span class="label mono">fi-br-interlining</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-interrogation"></i>
                    <span class="label mono">fi-br-interrogation</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-italic"></i>
                    <span class="label mono">fi-br-italic</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-jam"></i>
                    <span class="label mono">fi-br-jam</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-jpg"></i>
                    <span class="label mono">fi-br-jpg</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-key"></i>
                    <span class="label mono">fi-br-key</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-keyboard"></i>
                    <span class="label mono">fi-br-keyboard</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-kiss-beam"></i>
                    <span class="label mono">fi-br-kiss-beam</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-kiss-wink-heart"></i>
                    <span class="label mono">fi-br-kiss-wink-heart</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-kiss"></i>
                    <span class="label mono">fi-br-kiss</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-kite"></i>
                    <span class="label mono">fi-br-kite</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-knife"></i>
                    <span class="label mono">fi-br-knife</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-label"></i>
                    <span class="label mono">fi-br-label</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-laptop"></i>
                    <span class="label mono">fi-br-laptop</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-lasso"></i>
                    <span class="label mono">fi-br-lasso</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-laugh-beam"></i>
                    <span class="label mono">fi-br-laugh-beam</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-laugh-squint"></i>
                    <span class="label mono">fi-br-laugh-squint</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-laugh-wink"></i>
                    <span class="label mono">fi-br-laugh-wink</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-laugh"></i>
                    <span class="label mono">fi-br-laugh</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-layers"></i>
                    <span class="label mono">fi-br-layers</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-layout-fluid"></i>
                    <span class="label mono">fi-br-layout-fluid</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-leaf"></i>
                    <span class="label mono">fi-br-leaf</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-lemon"></i>
                    <span class="label mono">fi-br-lemon</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-letter-case"></i>
                    <span class="label mono">fi-br-letter-case</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-lettuce"></i>
                    <span class="label mono">fi-br-lettuce</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-level-down-alt"></i>
                    <span class="label mono">fi-br-level-down-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-level-down"></i>
                    <span class="label mono">fi-br-level-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-level-up-alt"></i>
                    <span class="label mono">fi-br-level-up-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-level-up"></i>
                    <span class="label mono">fi-br-level-up</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-life-ring"></i>
                    <span class="label mono">fi-br-life-ring</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-line-width"></i>
                    <span class="label mono">fi-br-line-width</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-link"></i>
                    <span class="label mono">fi-br-link</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-lipstick"></i>
                    <span class="label mono">fi-br-lipstick</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-list-check"></i>
                    <span class="label mono">fi-br-list-check</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-list"></i>
                    <span class="label mono">fi-br-list</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-loading"></i>
                    <span class="label mono">fi-br-loading</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-location-alt"></i>
                    <span class="label mono">fi-br-location-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-lock-alt"></i>
                    <span class="label mono">fi-br-lock-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-lock"></i>
                    <span class="label mono">fi-br-lock</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-luchador"></i>
                    <span class="label mono">fi-br-luchador</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-luggage-rolling"></i>
                    <span class="label mono">fi-br-luggage-rolling</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-magic-wand"></i>
                    <span class="label mono">fi-br-magic-wand</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-makeup-brush"></i>
                    <span class="label mono">fi-br-makeup-brush</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-male-couple"></i>
                    <span class="label mono">fi-br-male-couple</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-male"></i>
                    <span class="label mono">fi-br-male</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-man-head"></i>
                    <span class="label mono">fi-br-man-head</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-map-marker-cross"></i>
                    <span class="label mono">fi-br-map-marker-cross</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-map-marker-home"></i>
                    <span class="label mono">fi-br-map-marker-home</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-map-marker-minus"></i>
                    <span class="label mono">fi-br-map-marker-minus</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-map-marker-plus"></i>
                    <span class="label mono">fi-br-map-marker-plus</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-map-marker"></i>
                    <span class="label mono">fi-br-map-marker</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-map"></i>
                    <span class="label mono">fi-br-map</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-marker-time"></i>
                    <span class="label mono">fi-br-marker-time</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-marker"></i>
                    <span class="label mono">fi-br-marker</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-mask-carnival"></i>
                    <span class="label mono">fi-br-mask-carnival</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-medicine"></i>
                    <span class="label mono">fi-br-medicine</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-megaphone"></i>
                    <span class="label mono">fi-br-megaphone</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-meh-blank"></i>
                    <span class="label mono">fi-br-meh-blank</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-meh-rolling-eyes"></i>
                    <span class="label mono">fi-br-meh-rolling-eyes</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-melon"></i>
                    <span class="label mono">fi-br-melon</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-menu-burger"></i>
                    <span class="label mono">fi-br-menu-burger</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-menu-dots-vertical"></i>
                    <span class="label mono">fi-br-menu-dots-vertical</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-menu-dots"></i>
                    <span class="label mono">fi-br-menu-dots</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-meteor"></i>
                    <span class="label mono">fi-br-meteor</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-microphone-alt"></i>
                    <span class="label mono">fi-br-microphone-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-microphone"></i>
                    <span class="label mono">fi-br-microphone</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-minus-small"></i>
                    <span class="label mono">fi-br-minus-small</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-minus"></i>
                    <span class="label mono">fi-br-minus</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-mobile"></i>
                    <span class="label mono">fi-br-mobile</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-mode-landscape"></i>
                    <span class="label mono">fi-br-mode-landscape</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-mode-portrait"></i>
                    <span class="label mono">fi-br-mode-portrait</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-money"></i>
                    <span class="label mono">fi-br-money</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-moon-stars"></i>
                    <span class="label mono">fi-br-moon-stars</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-moon"></i>
                    <span class="label mono">fi-br-moon</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-motorcycle"></i>
                    <span class="label mono">fi-br-motorcycle</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-mountains"></i>
                    <span class="label mono">fi-br-mountains</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-mouse"></i>
                    <span class="label mono">fi-br-mouse</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-mug-alt"></i>
                    <span class="label mono">fi-br-mug-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-mug-hot-alt"></i>
                    <span class="label mono">fi-br-mug-hot-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-mug-hot"></i>
                    <span class="label mono">fi-br-mug-hot</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-mug-tea"></i>
                    <span class="label mono">fi-br-mug-tea</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-mug"></i>
                    <span class="label mono">fi-br-mug</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-mushroom"></i>
                    <span class="label mono">fi-br-mushroom</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-music-file"></i>
                    <span class="label mono">fi-br-music-file</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-music-alt"></i>
                    <span class="label mono">fi-br-music-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-music"></i>
                    <span class="label mono">fi-br-music</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-navigation"></i>
                    <span class="label mono">fi-br-navigation</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-network-cloud"></i>
                    <span class="label mono">fi-br-network-cloud</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-network"></i>
                    <span class="label mono">fi-br-network</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-noodles"></i>
                    <span class="label mono">fi-br-noodles</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-notebook"></i>
                    <span class="label mono">fi-br-notebook</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-oil-can"></i>
                    <span class="label mono">fi-br-oil-can</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-oil-temp"></i>
                    <span class="label mono">fi-br-oil-temp</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-olive-oil"></i>
                    <span class="label mono">fi-br-olive-oil</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-olives"></i>
                    <span class="label mono">fi-br-olives</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-onion"></i>
                    <span class="label mono">fi-br-onion</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-opacity"></i>
                    <span class="label mono">fi-br-opacity</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-package"></i>
                    <span class="label mono">fi-br-package</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-paint-brush"></i>
                    <span class="label mono">fi-br-paint-brush</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-palette"></i>
                    <span class="label mono">fi-br-palette</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-pan"></i>
                    <span class="label mono">fi-br-pan</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-paper-plane"></i>
                    <span class="label mono">fi-br-paper-plane</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-password"></i>
                    <span class="label mono">fi-br-password</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-pause"></i>
                    <span class="label mono">fi-br-pause</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-paw"></i>
                    <span class="label mono">fi-br-paw</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-peach"></i>
                    <span class="label mono">fi-br-peach</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-pencil"></i>
                    <span class="label mono">fi-br-pencil</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-pennant"></i>
                    <span class="label mono">fi-br-pennant</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-pepper-hot"></i>
                    <span class="label mono">fi-br-pepper-hot</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-pepper"></i>
                    <span class="label mono">fi-br-pepper</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-pharmacy"></i>
                    <span class="label mono">fi-br-pharmacy</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-phone-call"></i>
                    <span class="label mono">fi-br-phone-call</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-phone-cross"></i>
                    <span class="label mono">fi-br-phone-cross</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-phone-pause"></i>
                    <span class="label mono">fi-br-phone-pause</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-phone-slash"></i>
                    <span class="label mono">fi-br-phone-slash</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-physics"></i>
                    <span class="label mono">fi-br-physics</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-picnic"></i>
                    <span class="label mono">fi-br-picnic</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-picture"></i>
                    <span class="label mono">fi-br-picture</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-pie"></i>
                    <span class="label mono">fi-br-pie</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-pineapple"></i>
                    <span class="label mono">fi-br-pineapple</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-ping-pong"></i>
                    <span class="label mono">fi-br-ping-pong</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-pizza-slice"></i>
                    <span class="label mono">fi-br-pizza-slice</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-plane-alt"></i>
                    <span class="label mono">fi-br-plane-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-plane"></i>
                    <span class="label mono">fi-br-plane</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-plate"></i>
                    <span class="label mono">fi-br-plate</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-play-alt"></i>
                    <span class="label mono">fi-br-play-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-play"></i>
                    <span class="label mono">fi-br-play</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-playing-Domains"></i>
                    <span class="label mono">fi-br-playing-Domains</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-plus-small"></i>
                    <span class="label mono">fi-br-plus-small</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-plus"></i>
                    <span class="label mono">fi-br-plus</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-poker-chip"></i>
                    <span class="label mono">fi-br-poker-chip</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-poo"></i>
                    <span class="label mono">fi-br-poo</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-popcorn"></i>
                    <span class="label mono">fi-br-popcorn</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-portrait"></i>
                    <span class="label mono">fi-br-portrait</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-pot"></i>
                    <span class="label mono">fi-br-pot</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-pound"></i>
                    <span class="label mono">fi-br-pound</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-power"></i>
                    <span class="label mono">fi-br-power</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-presentation"></i>
                    <span class="label mono">fi-br-presentation</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-print"></i>
                    <span class="label mono">fi-br-print</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-protractor"></i>
                    <span class="label mono">fi-br-protractor</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-pulse"></i>
                    <span class="label mono">fi-br-pulse</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-pumpkin"></i>
                    <span class="label mono">fi-br-pumpkin</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-puzzle-piece"></i>
                    <span class="label mono">fi-br-puzzle-piece</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-pyramid"></i>
                    <span class="label mono">fi-br-pyramid</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-quote-right"></i>
                    <span class="label mono">fi-br-quote-right</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-radish"></i>
                    <span class="label mono">fi-br-radish</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-rainbow"></i>
                    <span class="label mono">fi-br-rainbow</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-raindrops"></i>
                    <span class="label mono">fi-br-raindrops</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-raquet"></i>
                    <span class="label mono">fi-br-raquet</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-rec"></i>
                    <span class="label mono">fi-br-rec</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-receipt"></i>
                    <span class="label mono">fi-br-receipt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-record-vinyl"></i>
                    <span class="label mono">fi-br-record-vinyl</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-rectabgle-vertical"></i>
                    <span class="label mono">fi-br-rectabgle-vertical</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-rectangle-horizontal"></i>
                    <span class="label mono">fi-br-rectangle-horizontal</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-rectangle-panoramic"></i>
                    <span class="label mono">fi-br-rectangle-panoramic</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-recycle"></i>
                    <span class="label mono">fi-br-recycle</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-redo-alt"></i>
                    <span class="label mono">fi-br-redo-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-redo"></i>
                    <span class="label mono">fi-br-redo</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-reflect"></i>
                    <span class="label mono">fi-br-reflect</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-refresh"></i>
                    <span class="label mono">fi-br-refresh</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-remove-user"></i>
                    <span class="label mono">fi-br-remove-user</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-reply-all"></i>
                    <span class="label mono">fi-br-reply-all</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-resize"></i>
                    <span class="label mono">fi-br-resize</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-resources"></i>
                    <span class="label mono">fi-br-resources</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-restaurant"></i>
                    <span class="label mono">fi-br-restaurant</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-rewind"></i>
                    <span class="label mono">fi-br-rewind</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-rhombus"></i>
                    <span class="label mono">fi-br-rhombus</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-rings-wedding"></i>
                    <span class="label mono">fi-br-rings-wedding</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-road"></i>
                    <span class="label mono">fi-br-road</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-rocket-lunch"></i>
                    <span class="label mono">fi-br-rocket-lunch</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-rocket"></i>
                    <span class="label mono">fi-br-rocket</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-room-service"></i>
                    <span class="label mono">fi-br-room-service</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-rotate-right"></i>
                    <span class="label mono">fi-br-rotate-right</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-rugby-helmet"></i>
                    <span class="label mono">fi-br-rugby-helmet</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-rugby"></i>
                    <span class="label mono">fi-br-rugby</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-running"></i>
                    <span class="label mono">fi-br-running</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-rv"></i>
                    <span class="label mono">fi-br-rv</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sad-cry"></i>
                    <span class="label mono">fi-br-sad-cry</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sad-tear"></i>
                    <span class="label mono">fi-br-sad-tear</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sad"></i>
                    <span class="label mono">fi-br-sad</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-salad"></i>
                    <span class="label mono">fi-br-salad</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-salt-pepper"></i>
                    <span class="label mono">fi-br-salt-pepper</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sandwich"></i>
                    <span class="label mono">fi-br-sandwich</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sauce"></i>
                    <span class="label mono">fi-br-sauce</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sausage"></i>
                    <span class="label mono">fi-br-sausage</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-scale"></i>
                    <span class="label mono">fi-br-scale</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-school-bus"></i>
                    <span class="label mono">fi-br-school-bus</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-school"></i>
                    <span class="label mono">fi-br-school</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-scissors"></i>
                    <span class="label mono">fi-br-scissors</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-screen"></i>
                    <span class="label mono">fi-br-screen</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-search-alt"></i>
                    <span class="label mono">fi-br-search-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-search-heart"></i>
                    <span class="label mono">fi-br-search-heart</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-search"></i>
                    <span class="label mono">fi-br-search</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-settings-sliders"></i>
                    <span class="label mono">fi-br-settings-sliders</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-settings"></i>
                    <span class="label mono">fi-br-settings</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-share"></i>
                    <span class="label mono">fi-br-share</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-shield-check"></i>
                    <span class="label mono">fi-br-shield-check</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-shield-exclamation"></i>
                    <span class="label mono">fi-br-shield-exclamation</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-shield-interrogation"></i>
                    <span class="label mono">fi-br-shield-interrogation</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-shield-plus"></i>
                    <span class="label mono">fi-br-shield-plus</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-shield"></i>
                    <span class="label mono">fi-br-shield</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-ship-side"></i>
                    <span class="label mono">fi-br-ship-side</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-ship"></i>
                    <span class="label mono">fi-br-ship</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-shop"></i>
                    <span class="label mono">fi-br-shop</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-shopping-bag-add"></i>
                    <span class="label mono">fi-br-shopping-bag-add</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-shopping-bag"></i>
                    <span class="label mono">fi-br-shopping-bag</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-shopping-cart-add"></i>
                    <span class="label mono">fi-br-shopping-cart-add</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-shopping-cart-check"></i>
                    <span class="label mono">fi-br-shopping-cart-check</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-shopping-cart"></i>
                    <span class="label mono">fi-br-shopping-cart</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-shrimp"></i>
                    <span class="label mono">fi-br-shrimp</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-shuffle"></i>
                    <span class="label mono">fi-br-shuffle</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-shuttle-van"></i>
                    <span class="label mono">fi-br-shuttle-van</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-shuttlecock"></i>
                    <span class="label mono">fi-br-shuttlecock</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sign-in-alt"></i>
                    <span class="label mono">fi-br-sign-in-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sign-in"></i>
                    <span class="label mono">fi-br-sign-in</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sign-out-alt"></i>
                    <span class="label mono">fi-br-sign-out-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sign-out"></i>
                    <span class="label mono">fi-br-sign-out</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-signal-alt-1"></i>
                    <span class="label mono">fi-br-signal-alt-1</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-signal-alt-2"></i>
                    <span class="label mono">fi-br-signal-alt-2</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-signal-alt"></i>
                    <span class="label mono">fi-br-signal-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-skateboard"></i>
                    <span class="label mono">fi-br-skateboard</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-skating"></i>
                    <span class="label mono">fi-br-skating</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-skewer"></i>
                    <span class="label mono">fi-br-skewer</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-ski-jump"></i>
                    <span class="label mono">fi-br-ski-jump</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-ski-lift"></i>
                    <span class="label mono">fi-br-ski-lift</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-skiing-nordic"></i>
                    <span class="label mono">fi-br-skiing-nordic</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-skiing"></i>
                    <span class="label mono">fi-br-skiing</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sledding"></i>
                    <span class="label mono">fi-br-sledding</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sleigh"></i>
                    <span class="label mono">fi-br-sleigh</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-smartphone"></i>
                    <span class="label mono">fi-br-smartphone</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-smile-beam"></i>
                    <span class="label mono">fi-br-smile-beam</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-smog"></i>
                    <span class="label mono">fi-br-smog</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-smoke"></i>
                    <span class="label mono">fi-br-smoke</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-snow-blowing"></i>
                    <span class="label mono">fi-br-snow-blowing</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-snowboarding"></i>
                    <span class="label mono">fi-br-snowboarding</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-snowflake"></i>
                    <span class="label mono">fi-br-snowflake</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-snowflakes"></i>
                    <span class="label mono">fi-br-snowflakes</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-snowmobile"></i>
                    <span class="label mono">fi-br-snowmobile</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-snowplow"></i>
                    <span class="label mono">fi-br-snowplow</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-soap"></i>
                    <span class="label mono">fi-br-soap</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sort-alpha-down-alt"></i>
                    <span class="label mono">fi-br-sort-alpha-down-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sort-alpha-down"></i>
                    <span class="label mono">fi-br-sort-alpha-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sort-alpha-up-alt"></i>
                    <span class="label mono">fi-br-sort-alpha-up-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sort-alpha-up"></i>
                    <span class="label mono">fi-br-sort-alpha-up</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sort-alt"></i>
                    <span class="label mono">fi-br-sort-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sort-amount-down-alt"></i>
                    <span class="label mono">fi-br-sort-amount-down-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sort-amount-down"></i>
                    <span class="label mono">fi-br-sort-amount-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sort-amount-up-alt"></i>
                    <span class="label mono">fi-br-sort-amount-up-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sort-amount-up"></i>
                    <span class="label mono">fi-br-sort-amount-up</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sort-down"></i>
                    <span class="label mono">fi-br-sort-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sort-numeric-down-alt"></i>
                    <span class="label mono">fi-br-sort-numeric-down-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sort-numeric-down"></i>
                    <span class="label mono">fi-br-sort-numeric-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sort"></i>
                    <span class="label mono">fi-br-sort</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-soup"></i>
                    <span class="label mono">fi-br-soup</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-spa"></i>
                    <span class="label mono">fi-br-spa</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-space-shuttle"></i>
                    <span class="label mono">fi-br-space-shuttle</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-spade"></i>
                    <span class="label mono">fi-br-spade</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sparkles"></i>
                    <span class="label mono">fi-br-sparkles</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-speaker"></i>
                    <span class="label mono">fi-br-speaker</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sphere"></i>
                    <span class="label mono">fi-br-sphere</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-spinner"></i>
                    <span class="label mono">fi-br-spinner</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-spoon"></i>
                    <span class="label mono">fi-br-spoon</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-square-root"></i>
                    <span class="label mono">fi-br-square-root</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-square"></i>
                    <span class="label mono">fi-br-square</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-star-octogram"></i>
                    <span class="label mono">fi-br-star-octogram</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-star"></i>
                    <span class="label mono">fi-br-star</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-starfighter"></i>
                    <span class="label mono">fi-br-starfighter</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-stars"></i>
                    <span class="label mono">fi-br-stars</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-stats"></i>
                    <span class="label mono">fi-br-stats</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-steak"></i>
                    <span class="label mono">fi-br-steak</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-steering-wheel"></i>
                    <span class="label mono">fi-br-steering-wheel</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-stethoscope"></i>
                    <span class="label mono">fi-br-stethoscope</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sticker"></i>
                    <span class="label mono">fi-br-sticker</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-stop"></i>
                    <span class="label mono">fi-br-stop</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-stopwatch"></i>
                    <span class="label mono">fi-br-stopwatch</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-strawberry"></i>
                    <span class="label mono">fi-br-strawberry</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-subtitles"></i>
                    <span class="label mono">fi-br-subtitles</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-subway"></i>
                    <span class="label mono">fi-br-subway</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sun"></i>
                    <span class="label mono">fi-br-sun</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sunrise-alt"></i>
                    <span class="label mono">fi-br-sunrise-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sunrise"></i>
                    <span class="label mono">fi-br-sunrise</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sunset"></i>
                    <span class="label mono">fi-br-sunset</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-surfing"></i>
                    <span class="label mono">fi-br-surfing</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-surprise"></i>
                    <span class="label mono">fi-br-surprise</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sushi"></i>
                    <span class="label mono">fi-br-sushi</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-swimmer"></i>
                    <span class="label mono">fi-br-swimmer</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-sword"></i>
                    <span class="label mono">fi-br-sword</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-syringe"></i>
                    <span class="label mono">fi-br-syringe</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tablet"></i>
                    <span class="label mono">fi-br-tablet</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tachometer-alt-average"></i>
                    <span class="label mono">fi-br-tachometer-alt-average</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tachometer-alt-fastest"></i>
                    <span class="label mono">fi-br-tachometer-alt-fastest</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tachometer-alt-slow"></i>
                    <span class="label mono">fi-br-tachometer-alt-slow</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tachometer-alt-slowest"></i>
                    <span class="label mono">fi-br-tachometer-alt-slowest</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tachometer-average"></i>
                    <span class="label mono">fi-br-tachometer-average</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tachometer-fast"></i>
                    <span class="label mono">fi-br-tachometer-fast</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tachometer-fastest"></i>
                    <span class="label mono">fi-br-tachometer-fastest</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tachometer-slow"></i>
                    <span class="label mono">fi-br-tachometer-slow</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tachometer-slowest"></i>
                    <span class="label mono">fi-br-tachometer-slowest</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tachometer"></i>
                    <span class="label mono">fi-br-tachometer</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-taco"></i>
                    <span class="label mono">fi-br-taco</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-target"></i>
                    <span class="label mono">fi-br-target</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-taxi"></i>
                    <span class="label mono">fi-br-taxi</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-temperature-down"></i>
                    <span class="label mono">fi-br-temperature-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-temperature-frigid"></i>
                    <span class="label mono">fi-br-temperature-frigid</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-temperature-high"></i>
                    <span class="label mono">fi-br-temperature-high</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-temperature-hot"></i>
                    <span class="label mono">fi-br-temperature-hot</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-temperature-low"></i>
                    <span class="label mono">fi-br-temperature-low</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-temperature-up"></i>
                    <span class="label mono">fi-br-temperature-up</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tennis"></i>
                    <span class="label mono">fi-br-tennis</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-terrace"></i>
                    <span class="label mono">fi-br-terrace</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-test-tube"></i>
                    <span class="label mono">fi-br-test-tube</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-test"></i>
                    <span class="label mono">fi-br-test</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-text-check"></i>
                    <span class="label mono">fi-br-text-check</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-text"></i>
                    <span class="label mono">fi-br-text</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-thermometer-half"></i>
                    <span class="label mono">fi-br-thermometer-half</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-thumbs-down"></i>
                    <span class="label mono">fi-br-thumbs-down</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-thumbs-up"></i>
                    <span class="label mono">fi-br-thumbs-up</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-thumbtack"></i>
                    <span class="label mono">fi-br-thumbtack</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-thunderstorm-moon"></i>
                    <span class="label mono">fi-br-thunderstorm-moon</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-thunderstorm-sun"></i>
                    <span class="label mono">fi-br-thunderstorm-sun</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-thunderstorm"></i>
                    <span class="label mono">fi-br-thunderstorm</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-ticket"></i>
                    <span class="label mono">fi-br-ticket</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-time-add"></i>
                    <span class="label mono">fi-br-time-add</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-time-check"></i>
                    <span class="label mono">fi-br-time-check</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-time-delete"></i>
                    <span class="label mono">fi-br-time-delete</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-time-fast"></i>
                    <span class="label mono">fi-br-time-fast</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-time-forward-sixty"></i>
                    <span class="label mono">fi-br-time-forward-sixty</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-time-forward-ten"></i>
                    <span class="label mono">fi-br-time-forward-ten</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-time-forward"></i>
                    <span class="label mono">fi-br-time-forward</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-time-half-past"></i>
                    <span class="label mono">fi-br-time-half-past</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-time-oclock"></i>
                    <span class="label mono">fi-br-time-oclock</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-time-past"></i>
                    <span class="label mono">fi-br-time-past</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-time-quarter-to"></i>
                    <span class="label mono">fi-br-time-quarter-to</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-time-quarter-past"></i>
                    <span class="label mono">fi-br-time-quarter-past</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-time-twenty-four"></i>
                    <span class="label mono">fi-br-time-twenty-four</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tire-flat"></i>
                    <span class="label mono">fi-br-tire-flat</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tire-pressure-warning"></i>
                    <span class="label mono">fi-br-tire-pressure-warning</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tire-rugged"></i>
                    <span class="label mono">fi-br-tire-rugged</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tire"></i>
                    <span class="label mono">fi-br-tire</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tired"></i>
                    <span class="label mono">fi-br-tired</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tomato"></i>
                    <span class="label mono">fi-br-tomato</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tool-crop"></i>
                    <span class="label mono">fi-br-tool-crop</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tool-marquee"></i>
                    <span class="label mono">fi-br-tool-marquee</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tooth"></i>
                    <span class="label mono">fi-br-tooth</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tornado"></i>
                    <span class="label mono">fi-br-tornado</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tractor"></i>
                    <span class="label mono">fi-br-tractor</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-trailer"></i>
                    <span class="label mono">fi-br-trailer</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-train-side"></i>
                    <span class="label mono">fi-br-train-side</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-train"></i>
                    <span class="label mono">fi-br-train</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tram"></i>
                    <span class="label mono">fi-br-tram</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-transform"></i>
                    <span class="label mono">fi-br-transform</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-trash"></i>
                    <span class="label mono">fi-br-trash</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-treatment"></i>
                    <span class="label mono">fi-br-treatment</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tree-christmas"></i>
                    <span class="label mono">fi-br-tree-christmas</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tree"></i>
                    <span class="label mono">fi-br-tree</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-triangle"></i>
                    <span class="label mono">fi-br-triangle</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-trophy"></i>
                    <span class="label mono">fi-br-trophy</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-truck-container"></i>
                    <span class="label mono">fi-br-truck-container</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-truck-couch"></i>
                    <span class="label mono">fi-br-truck-couch</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-truck-loading"></i>
                    <span class="label mono">fi-br-truck-loading</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-truck-monster"></i>
                    <span class="label mono">fi-br-truck-monster</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-truck-moving"></i>
                    <span class="label mono">fi-br-truck-moving</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-truck-pickup"></i>
                    <span class="label mono">fi-br-truck-pickup</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-truck-plow"></i>
                    <span class="label mono">fi-br-truck-plow</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-truck-ramp"></i>
                    <span class="label mono">fi-br-truck-ramp</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-truck-side"></i>
                    <span class="label mono">fi-br-truck-side</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-tty"></i>
                    <span class="label mono">fi-br-tty</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-turkey"></i>
                    <span class="label mono">fi-br-turkey</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-umbrella"></i>
                    <span class="label mono">fi-br-umbrella</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-underline"></i>
                    <span class="label mono">fi-br-underline</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-undo-alt"></i>
                    <span class="label mono">fi-br-undo-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-undo"></i>
                    <span class="label mono">fi-br-undo</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-unlock"></i>
                    <span class="label mono">fi-br-unlock</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-upload"></i>
                    <span class="label mono">fi-br-upload</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-usb-pendrive"></i>
                    <span class="label mono">fi-br-usb-pendrive</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-user-add"></i>
                    <span class="label mono">fi-br-user-add</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-user-time"></i>
                    <span class="label mono">fi-br-user-time</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-user"></i>
                    <span class="label mono">fi-br-user</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-users-alt"></i>
                    <span class="label mono">fi-br-users-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-users"></i>
                    <span class="label mono">fi-br-users</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-utensils"></i>
                    <span class="label mono">fi-br-utensils</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-vector-alt"></i>
                    <span class="label mono">fi-br-vector-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-vector"></i>
                    <span class="label mono">fi-br-vector</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-video-camera"></i>
                    <span class="label mono">fi-br-video-camera</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-volcano"></i>
                    <span class="label mono">fi-br-volcano</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-volleyball"></i>
                    <span class="label mono">fi-br-volleyball</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-volume"></i>
                    <span class="label mono">fi-br-volume</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-wagon-covered"></i>
                    <span class="label mono">fi-br-wagon-covered</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-water-bottle"></i>
                    <span class="label mono">fi-br-water-bottle</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-water-lower"></i>
                    <span class="label mono">fi-br-water-lower</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-water-rise"></i>
                    <span class="label mono">fi-br-water-rise</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-water"></i>
                    <span class="label mono">fi-br-water</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-watermelon"></i>
                    <span class="label mono">fi-br-watermelon</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-wheat"></i>
                    <span class="label mono">fi-br-wheat</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-wheelchair"></i>
                    <span class="label mono">fi-br-wheelchair</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-whistle"></i>
                    <span class="label mono">fi-br-whistle</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-wifi-alt"></i>
                    <span class="label mono">fi-br-wifi-alt</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-wind-warning"></i>
                    <span class="label mono">fi-br-wind-warning</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-wind"></i>
                    <span class="label mono">fi-br-wind</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-windsock"></i>
                    <span class="label mono">fi-br-windsock</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-wink"></i>
                    <span class="label mono">fi-br-wink</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-woman-head"></i>
                    <span class="label mono">fi-br-woman-head</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-world"></i>
                    <span class="label mono">fi-br-world</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-yen"></i>
                    <span class="label mono">fi-br-yen</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-zoom-in"></i>
                    <span class="label mono">fi-br-zoom-in</span>
                </div>
            </li>


            <li>
                <div class="icon-holder">
                    <i class="fi fi-br-zoom-out"></i>
                    <span class="label mono">fi-br-zoom-out</span>
                </div>
            </li>


    </ul>
</div>
</body>
</html>
