<?php
class SqlDados
{
    private $mysql;

    public function __construct(mysqli $mysql)
    {
        $this->mysql = $mysql;
    }
    public function getDomainData(): array
    {
        $query = $this->mysql->query('SELECT * FROM domains ORDER BY domainDate DESC');
        $results = $query->fetch_all(MYSQLI_ASSOC);
        return $results;
    }
    public function getdomainDate(int $domainID): array
    {
        $prepare = $this->mysql->prepare("SELECT * FROM domains WHERE domainID = ?");
        $prepare->bind_param('s', $domainID);
        $prepare->execute();
        $results = $prepare->get_result()->fetch_assoc();
        return $results;
    }
    public function addNewDomain(string $domainName, string $domainStatus, string $domainDescription, string $domainPlesk, string $domainPleskD, string $domainCreator, string $domainClient): void
    {
        $prepare = $this->mysql->prepare('INSERT INTO domains (domainName, domainStatus, domainDate, domainDescription, domainPlesk, domainPleskD, domainCreator, domainClient) SELECT ?, ?, DATE_FORMAT(CURRENT_TIMESTAMP(), "%d/%m/%Y %H:%i:%s"), ?, ?, ?, ?, ? FROM dual WHERE NOT EXISTS (SELECT domainName FROM domains WHERE domainName = ?)');
        $prepare->bind_param('ssssssss', $domainName, $domainStatus, $domainDescription, $domainPlesk, $domainPleskD, $domainCreator, $domainClient, $domainName);
        $prepare->execute();

    }
    public function removeDomain(string $domainID): void
    {
        $prepare = $this->mysql->prepare('DELETE FROM domains WHERE domainID = ?');
        $prepare->bind_param('s', $domainID);
        $prepare->execute();
    }
    public function editDomain(string $domainName, string $domainStatus, string $domainDescription, string $domainPlesk, string $domainPleskD, string $domainEditor, string $domainClient, string $domainID): void
    {
        $prepare = $this->mysql->prepare('UPDATE domains SET domainName = ?, domainStatus = ?, domainDate = DATE_FORMAT(CURRENT_TIMESTAMP(), "%d/%m/%Y %H:%i:%s"), domainDescription = ?, domainPlesk = ?, domainPleskD = ?, domainEditor = ?, domainClient = ? WHERE domainID = ?');
        $prepare->bind_param('ssssssss', $domainName, $domainStatus, $domainDescription, $domainPlesk, $domainPleskD, $domainEditor, $domainClient, $domainID);
        $prepare->execute();
    }
    public function search(string $word): array
    {
        $parameter = "%" . $word . "%";
        $prepare = $this->mysql->prepare('SELECT *  FROM domains WHERE (domainName LIKE ? ) OR (domainClient LIKE ? ) ORDER BY domainID DESC');
        $prepare->bind_param('ss', $parameter, $parameter);
        $prepare->execute();
        $results = $prepare->get_result()->fetch_all(MYSQLI_ASSOC);

        return $results;
    }
    public function filter(string $word): array
    {
        $parameter = "%" . $word . "%";
        $prepare = $this->mysql->prepare('SELECT *  FROM domains WHERE (domainName LIKE ? ) OR (domainDescription LIKE ? ) OR (domainDate LIKE ? ) OR (domainClient LIKE ? ) OR (domainStatus LIKE ? ) OR (domainPlesk LIKE ? ) ORDER BY domainID DESC');
        $prepare->bind_param('ssssss', $parameter, $parameter, $parameter, $parameter, $parameter, $parameter);
        $prepare->execute();
        $results = $prepare->get_result()->fetch_all(MYSQLI_ASSOC);

        return $results;
    }
    public function editWhereLike(string $colun, string $colunInformation, string $colunDestination, string $colunDestinationValue,string $editor): array
    {
        $parameter = "%" . $colunInformation . "%";
        $query="UPDATE domains SET $colunDestination = ?, domainEditor = ? WHERE $colun LIKE ?";
        $prepare = $this->mysql->prepare($query);
        $prepare->bind_param('sss', $colunDestinationValue, $editor, $parameter);
        $prepare->execute();
        $results = $prepare->get_result()->fetch_all(MYSQLI_ASSOC);

        return $results;
    }
}
